/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client;

import io.jenkins.cli.shaded.org.apache.sshd.client.SshClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.DefaultConfigFileHostEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.keys.ClientIdentityLoader;
import io.jenkins.cli.shaded.org.apache.sshd.client.global.OpenSshHostKeysHandler;
import io.jenkins.cli.shaded.org.apache.sshd.client.kex.DHGClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.kex.DHGEXClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.common.BaseBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.BuiltinCompressions;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.Compression;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.DHFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchangeFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.ForwardedTcpipFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ClientBuilder
extends BaseBuilder<SshClient, ClientBuilder> {
    public static final Function<DHFactory, KeyExchangeFactory> DH2KEX = factory -> factory == null ? null : (factory.isGroupExchange() ? DHGEXClient.newFactory(factory) : DHGClient.newFactory(factory));
    public static final List<CompressionFactory> DEFAULT_COMPRESSION_FACTORIES = Collections.unmodifiableList(Collections.singletonList(BuiltinCompressions.none));
    public static final List<ChannelFactory> DEFAULT_CHANNEL_FACTORIES = Collections.unmodifiableList(Collections.singletonList(ForwardedTcpipFactory.INSTANCE));
    public static final List<RequestHandler<ConnectionService>> DEFAULT_GLOBAL_REQUEST_HANDLERS = Collections.unmodifiableList(Collections.singletonList(OpenSshHostKeysHandler.INSTANCE));
    public static final ServerKeyVerifier DEFAULT_SERVER_KEY_VERIFIER = AcceptAllServerKeyVerifier.INSTANCE;
    public static final HostConfigEntryResolver DEFAULT_HOST_CONFIG_ENTRY_RESOLVER = DefaultConfigFileHostEntryResolver.INSTANCE;
    public static final ClientIdentityLoader DEFAULT_CLIENT_IDENTITY_LOADER = ClientIdentityLoader.DEFAULT;
    public static final FilePasswordProvider DEFAULT_FILE_PASSWORD_PROVIDER = FilePasswordProvider.EMPTY;
    protected ServerKeyVerifier serverKeyVerifier;
    protected HostConfigEntryResolver hostConfigEntryResolver;
    protected ClientIdentityLoader clientIdentityLoader;
    protected FilePasswordProvider filePasswordProvider;

    public ClientBuilder serverKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
        return (ClientBuilder)this.me();
    }

    public ClientBuilder hostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = resolver;
        return (ClientBuilder)this.me();
    }

    public ClientBuilder clientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = loader;
        return (ClientBuilder)this.me();
    }

    public ClientBuilder filePasswordProvider(FilePasswordProvider provider) {
        this.filePasswordProvider = provider;
        return (ClientBuilder)this.me();
    }

    @Override
    protected ClientBuilder fillWithDefaultValues() {
        super.fillWithDefaultValues();
        if (this.signatureFactories == null) {
            this.signatureFactories = ClientBuilder.setUpDefaultSignatureFactories(false);
        }
        if (this.compressionFactories == null) {
            this.compressionFactories = ClientBuilder.setUpDefaultCompressionFactories(false);
        }
        if (this.keyExchangeFactories == null) {
            this.keyExchangeFactories = ClientBuilder.setUpDefaultKeyExchanges(false);
        }
        if (this.channelFactories == null) {
            this.channelFactories = DEFAULT_CHANNEL_FACTORIES;
        }
        if (this.globalRequestHandlers == null) {
            this.globalRequestHandlers = DEFAULT_GLOBAL_REQUEST_HANDLERS;
        }
        if (this.serverKeyVerifier == null) {
            this.serverKeyVerifier = DEFAULT_SERVER_KEY_VERIFIER;
        }
        if (this.hostConfigEntryResolver == null) {
            this.hostConfigEntryResolver = DEFAULT_HOST_CONFIG_ENTRY_RESOLVER;
        }
        if (this.clientIdentityLoader == null) {
            this.clientIdentityLoader = DEFAULT_CLIENT_IDENTITY_LOADER;
        }
        if (this.filePasswordProvider == null) {
            this.filePasswordProvider = DEFAULT_FILE_PASSWORD_PROVIDER;
        }
        if (this.factory == null) {
            this.factory = SshClient.DEFAULT_SSH_CLIENT_FACTORY;
        }
        return (ClientBuilder)this.me();
    }

    @Override
    public SshClient build(boolean isFillWithDefaultValues) {
        SshClient client = (SshClient)super.build(isFillWithDefaultValues);
        client.setServerKeyVerifier(this.serverKeyVerifier);
        client.setHostConfigEntryResolver(this.hostConfigEntryResolver);
        client.setClientIdentityLoader(this.clientIdentityLoader);
        client.setFilePasswordProvider(this.filePasswordProvider);
        return client;
    }

    public static List<NamedFactory<Signature>> setUpDefaultSignatureFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_SIGNATURE_PREFERENCE);
    }

    public static List<NamedFactory<Compression>> setUpDefaultCompressionFactories(boolean ignoreUnsupported) {
        return NamedFactory.setUpBuiltinFactories(ignoreUnsupported, DEFAULT_COMPRESSION_FACTORIES);
    }

    public static List<KeyExchangeFactory> setUpDefaultKeyExchanges(boolean ignoreUnsupported) {
        return NamedFactory.setUpTransformedFactories(ignoreUnsupported, DEFAULT_KEX_PREFERENCE, DH2KEX);
    }

    public static ClientBuilder builder() {
        return new ClientBuilder();
    }
}

