/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard;

import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.InteractiveChallenge;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.password.PasswordAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.util.List;

public class DefaultKeyboardInteractiveAuthenticator
extends AbstractLoggingBean
implements KeyboardInteractiveAuthenticator {
    public static final String KB_INTERACTIVE_NAME_PROP = "kb-server-interactive-name";
    public static final String DEFAULT_KB_INTERACTIVE_NAME = "Password authentication";
    public static final String KB_INTERACTIVE_INSTRUCTION_PROP = "kb-server-interactive-instruction";
    public static final String DEFAULT_KB_INTERACTIVE_INSTRUCTION = "";
    public static final String KB_INTERACTIVE_LANG_PROP = "kb-server-interactive-language";
    public static final String DEFAULT_KB_INTERACTIVE_LANG = "en-US";
    public static final String KB_INTERACTIVE_PROMPT_PROP = "kb-server-interactive-prompt";
    public static final String DEFAULT_KB_INTERACTIVE_PROMPT = "Password: ";
    public static final String KB_INTERACTIVE_ECHO_PROMPT_PROP = "kb-server-interactive-echo-prompt";
    public static final boolean DEFAULT_KB_INTERACTIVE_ECHO_PROMPT = false;
    public static final DefaultKeyboardInteractiveAuthenticator INSTANCE = new DefaultKeyboardInteractiveAuthenticator();

    @Override
    public InteractiveChallenge generateChallenge(ServerSession session, String username, String lang, String subMethods) throws Exception {
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("generateChallenge({})[{}] no password authenticator", (Object)session, (Object)username);
            }
            return null;
        }
        InteractiveChallenge challenge = new InteractiveChallenge();
        challenge.setInteractionName(this.getInteractionName(session));
        challenge.setInteractionInstruction(this.getInteractionInstruction(session));
        challenge.setLanguageTag(this.getInteractionLanguage(session));
        challenge.addPrompt(this.getInteractionPrompt(session), this.isInteractionPromptEchoEnabled(session));
        return challenge;
    }

    @Override
    public boolean authenticate(ServerSession session, String username, List<String> responses) throws Exception {
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate({})[{}] no password authenticator", (Object)session, (Object)username);
            }
            return false;
        }
        int numResp = GenericUtils.size(responses);
        if (numResp != 1) {
            throw new SshException("Mismatched number of responses");
        }
        try {
            return auth.authenticate(username, responses.get(0), session);
        }
        catch (Error e) {
            this.log.warn("authenticate({})[{}] failed ({}) to consult password authenticator: {}", session, username, e.getClass().getSimpleName(), e.getMessage());
            if (this.log.isDebugEnabled()) {
                this.log.debug("authenticate(" + session + ")[" + username + "] authenticator failure details", e);
            }
            throw new RuntimeSshException(e);
        }
    }

    protected String getInteractionName(ServerSession session) {
        return session.getStringProperty(KB_INTERACTIVE_NAME_PROP, DEFAULT_KB_INTERACTIVE_NAME);
    }

    protected String getInteractionInstruction(ServerSession session) {
        return session.getStringProperty(KB_INTERACTIVE_INSTRUCTION_PROP, DEFAULT_KB_INTERACTIVE_INSTRUCTION);
    }

    protected String getInteractionLanguage(ServerSession session) {
        return session.getStringProperty(KB_INTERACTIVE_LANG_PROP, DEFAULT_KB_INTERACTIVE_LANG);
    }

    protected String getInteractionPrompt(ServerSession session) {
        return session.getStringProperty(KB_INTERACTIVE_PROMPT_PROP, DEFAULT_KB_INTERACTIVE_PROMPT);
    }

    protected boolean isInteractionPromptEchoEnabled(ServerSession session) {
        return session.getBooleanProperty(KB_INTERACTIVE_ECHO_PROMPT_PROP, false);
    }
}

