/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgent;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import java.security.PublicKey;
import java.util.Objects;

public class KeyAgentIdentity
implements PublicKeyIdentity {
    private final SshAgent agent;
    private final PublicKey key;
    private final String comment;

    public KeyAgentIdentity(SshAgent agent, PublicKey key, String comment) {
        this.agent = Objects.requireNonNull(agent, "No signing agent");
        this.key = Objects.requireNonNull(key, "No public key");
        this.comment = comment;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.key;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public byte[] sign(SessionContext session, byte[] data) throws Exception {
        return this.agent.sign(session, this.getPublicKey(), data);
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + "[" + KeyUtils.getKeyType(pubKey) + "] fingerprint=" + KeyUtils.getFingerPrint(pubKey) + ", comment=" + this.getComment();
    }
}

