/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider;

import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.MultiKeyIdentityIterator;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.MultiKeyIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

@FunctionalInterface
public interface KeyIdentityProvider {
    public static final KeyIdentityProvider EMPTY_KEYS_PROVIDER = new KeyIdentityProvider(){

        @Override
        public Iterable<KeyPair> loadKeys(SessionContext session) {
            return Collections.emptyList();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public Iterable<KeyPair> loadKeys(SessionContext var1) throws IOException, GeneralSecurityException;

    public static boolean isEmpty(KeyIdentityProvider provider) {
        return provider == null || GenericUtils.isSameReference(provider, EMPTY_KEYS_PROVIDER);
    }

    public static KeyIdentityProvider resolveKeyIdentityProvider(KeyIdentityProvider identities, KeyIdentityProvider keys) {
        if (KeyIdentityProvider.isEmpty(keys) || GenericUtils.isSameReference(identities, keys)) {
            return identities == null ? keys : identities;
        }
        if (KeyIdentityProvider.isEmpty(identities)) {
            return keys;
        }
        return KeyIdentityProvider.multiProvider(identities, keys);
    }

    public static KeyIdentityProvider multiProvider(KeyIdentityProvider ... providers) {
        return KeyIdentityProvider.multiProvider(GenericUtils.asList(providers));
    }

    public static KeyIdentityProvider multiProvider(Collection<? extends KeyIdentityProvider> providers) {
        int numProviders = GenericUtils.size(providers);
        if (numProviders <= 0) {
            return EMPTY_KEYS_PROVIDER;
        }
        if (numProviders == 1) {
            return GenericUtils.head(providers);
        }
        return new MultiKeyIdentityProvider(providers);
    }

    public static Iterable<KeyPair> iterableOf(final SessionContext session, final Collection<? extends KeyIdentityProvider> providers) {
        int numProviders = GenericUtils.size(providers);
        if (numProviders <= 0) {
            return Collections.emptyList();
        }
        if (numProviders == 1) {
            KeyIdentityProvider p = GenericUtils.head(providers);
            try {
                return p.loadKeys(session);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + ") keys loading exception: " + e.getMessage(), e);
            }
        }
        return new Iterable<KeyPair>(){

            @Override
            public Iterator<KeyPair> iterator() {
                return new MultiKeyIdentityIterator(session, providers);
            }

            public String toString() {
                return Iterable.class.getSimpleName() + "[of(providers)]";
            }
        };
    }

    public static KeyIdentityProvider wrapKeyPairs(KeyPair ... pairs) {
        return KeyIdentityProvider.wrapKeyPairs(GenericUtils.asList(pairs));
    }

    public static KeyIdentityProvider wrapKeyPairs(Iterable<KeyPair> pairs) {
        return pairs == null ? EMPTY_KEYS_PROVIDER : session -> pairs;
    }

    public static KeyPair exhaustCurrentIdentities(Iterator<? extends KeyPair> ids) {
        while (ids != null && ids.hasNext()) {
            KeyPair kp = ids.next();
            if (kp == null) continue;
            return kp;
        }
        return null;
    }
}

