/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.keyprovider;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.AbstractKeyPairProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractGeneratorHostKeyProvider
extends AbstractKeyPairProvider {
    public static final String DEFAULT_ALGORITHM = "RSA";
    public static final boolean DEFAULT_ALLOWED_TO_OVERWRITE = true;
    private final AtomicReference<KeyPair> keyPairHolder = new AtomicReference();
    private Path path;
    private String algorithm = "RSA";
    private int keySize;
    private AlgorithmParameterSpec keySpec;
    private boolean overwriteAllowed = true;

    protected AbstractGeneratorHostKeyProvider() {
    }

    public Path getPath() {
        return this.path;
    }

    public void setFile(File file) {
        this.setPath(file == null ? null : file.toPath());
    }

    public void setPath(Path path) {
        this.path = path == null ? null : path.toAbsolutePath();
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public AlgorithmParameterSpec getKeySpec() {
        return this.keySpec;
    }

    public void setKeySpec(AlgorithmParameterSpec keySpec) {
        this.keySpec = keySpec;
    }

    public boolean isOverwriteAllowed() {
        return this.overwriteAllowed;
    }

    public void setOverwriteAllowed(boolean overwriteAllowed) {
        this.overwriteAllowed = overwriteAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLoadedKeys() {
        KeyPair kp;
        AtomicReference<KeyPair> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            kp = this.keyPairHolder.getAndSet(null);
        }
        if (kp != null & this.log.isDebugEnabled()) {
            PublicKey key = kp.getPublic();
            this.log.debug("clearLoadedKeys({}) removed key={}-{}", this.getPath(), KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<KeyPair> loadKeys() {
        KeyPair kp;
        Path keyPath = this.getPath();
        AtomicReference<KeyPair> atomicReference = this.keyPairHolder;
        synchronized (atomicReference) {
            block8: {
                kp = this.keyPairHolder.get();
                if (kp == null) {
                    try {
                        kp = this.resolveKeyPair(keyPath);
                        if (kp != null) {
                            this.keyPairHolder.set(kp);
                        }
                    }
                    catch (Throwable t) {
                        this.log.warn("loadKeys({}) Failed ({}) to resolve: {}", keyPath, t.getClass().getSimpleName(), t.getMessage());
                        if (!this.log.isDebugEnabled()) break block8;
                        this.log.debug("loadKeys(" + keyPath + ") resolution failure details", t);
                    }
                }
            }
        }
        if (kp == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(kp);
    }

    protected KeyPair resolveKeyPair(Path keyPath) throws IOException, GeneralSecurityException {
        KeyPair kp;
        block13: {
            String alg;
            block12: {
                alg = this.getAlgorithm();
                if (keyPath != null) {
                    try {
                        kp = this.loadFromFile(alg, keyPath);
                        if (kp != null) {
                            return kp;
                        }
                    }
                    catch (Throwable e) {
                        this.log.warn("resolveKeyPair({}) Failed ({}) to load: {}", keyPath, e.getClass().getSimpleName(), e.getMessage());
                        if (!this.log.isDebugEnabled()) break block12;
                        this.log.debug("resolveKeyPair(" + keyPath + ") load failure details", e);
                    }
                }
            }
            try {
                kp = this.generateKeyPair(alg);
                if (kp == null) {
                    return null;
                }
                if (this.log.isDebugEnabled()) {
                    PublicKey key = kp.getPublic();
                    this.log.debug("resolveKeyPair({}) generated {} key={}-{}", keyPath, alg, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
                }
            }
            catch (Throwable e) {
                this.log.warn("resolveKeyPair({})[{}] Failed ({}) to generate {} key-pair: {}", keyPath, alg, e.getClass().getSimpleName(), alg, e.getMessage());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("resolveKeyPair(" + keyPath + ")[" + alg + "] key-pair generation failure details", e);
                }
                return null;
            }
            if (keyPath != null) {
                try {
                    this.writeKeyPair(kp, keyPath, new OpenOption[0]);
                }
                catch (Throwable e) {
                    this.log.warn("resolveKeyPair({})[{}] Failed ({}) to write {} key: {}", alg, keyPath, e.getClass().getSimpleName(), alg, e.getMessage());
                    if (!this.log.isDebugEnabled()) break block13;
                    this.log.debug("resolveKeyPair(" + keyPath + ")[" + alg + "] write failure details", e);
                }
            }
        }
        return kp;
    }

    protected KeyPair loadFromFile(String alg, Path keyPath) throws IOException, GeneralSecurityException {
        LinkOption[] options = IoUtils.getLinkOptions(true);
        if (!Files.exists(keyPath, options) || !Files.isRegularFile(keyPath, options)) {
            return null;
        }
        KeyPair kp = this.readKeyPair(keyPath, IoUtils.EMPTY_OPEN_OPTIONS);
        if (kp == null) {
            return null;
        }
        PublicKey key = kp.getPublic();
        String keyAlgorithm = key.getAlgorithm();
        if ("ECDSA".equalsIgnoreCase(keyAlgorithm)) {
            keyAlgorithm = "EC";
        } else if ("ED25519".equalsIgnoreCase(keyAlgorithm)) {
            keyAlgorithm = "EdDSA";
        }
        if (Objects.equals(alg, keyAlgorithm)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("resolveKeyPair({}) loaded key={}-{}", keyPath, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
            }
            return kp;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveKeyPair({}) mismatched loaded key algorithm: expected={}, loaded={}", keyPath, alg, keyAlgorithm);
        }
        Files.deleteIfExists(keyPath);
        return null;
    }

    protected KeyPair readKeyPair(Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = Files.newInputStream(keyPath, options);){
            KeyPair keyPair = this.doReadKeyPair(keyPath.toString(), inputStream);
            return keyPair;
        }
    }

    protected KeyPair doReadKeyPair(String resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
        return SecurityUtils.loadKeyPairIdentity(resourceKey, inputStream, null);
    }

    protected void writeKeyPair(KeyPair kp, Path keyPath, OpenOption ... options) throws IOException, GeneralSecurityException {
        block16: {
            if (!Files.exists(keyPath, new LinkOption[0]) || this.isOverwriteAllowed()) {
                try (OutputStream os = Files.newOutputStream(keyPath, options);){
                    this.doWriteKeyPair(keyPath.toString(), kp, os);
                    break block16;
                }
                catch (Throwable e) {
                    this.log.warn("writeKeyPair({}) failed ({}) to write key {}: {}", keyPath, e.getClass().getSimpleName(), e.getMessage());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("writeKeyPair(" + keyPath + ") write failure details", e);
                    }
                    break block16;
                }
            }
            this.log.error("Overwriting key ({}) is disabled: using throwaway {}: {}", keyPath, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp == null ? null : kp.getPublic()));
        }
    }

    protected abstract void doWriteKeyPair(String var1, KeyPair var2, OutputStream var3) throws IOException, GeneralSecurityException;

    protected KeyPair generateKeyPair(String algorithm) throws GeneralSecurityException {
        KeyPairGenerator generator = SecurityUtils.getKeyPairGenerator(algorithm);
        if (this.keySpec != null) {
            generator.initialize(this.keySpec);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - spec=" + this.keySpec.getClass().getSimpleName());
        } else if (this.keySize != 0) {
            generator.initialize(this.keySize);
            this.log.info("generateKeyPair(" + algorithm + ") generating host key - size=" + this.keySize);
        } else if ("EC".equals(algorithm)) {
            int numCurves = ECCurves.SORTED_KEY_SIZE.size();
            ECCurves curve = ECCurves.SORTED_KEY_SIZE.get(numCurves - 1);
            generator.initialize(curve.getParameters());
        }
        return generator.generateKeyPair();
    }
}

