/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.common.subsystem.sftp.SftpException;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SftpRemotePathChannel
extends FileChannel {
    public static final String COPY_BUFSIZE_PROP = "sftp-channel-copy-buf-size";
    public static final int DEFAULT_TRANSFER_BUFFER_SIZE = 8192;
    public static final Set<SftpClient.OpenMode> READ_MODES = Collections.unmodifiableSet(EnumSet.of(SftpClient.OpenMode.Read));
    public static final Set<SftpClient.OpenMode> WRITE_MODES = Collections.unmodifiableSet(EnumSet.of(SftpClient.OpenMode.Write, SftpClient.OpenMode.Append, SftpClient.OpenMode.Create, SftpClient.OpenMode.Truncate));
    private final String path;
    private final Collection<SftpClient.OpenMode> modes;
    private final boolean closeOnExit;
    private final SftpClient sftp;
    private final SftpClient.CloseableHandle handle;
    private final Object lock = new Object();
    private final AtomicLong posTracker = new AtomicLong(0L);
    private final AtomicReference<Thread> blockingThreadHolder = new AtomicReference<Object>(null);

    public SftpRemotePathChannel(String path, SftpClient sftp, boolean closeOnExit, Collection<SftpClient.OpenMode> modes) throws IOException {
        this.path = ValidateUtils.checkNotNullAndNotEmpty(path, "No remote file path specified");
        this.modes = Objects.requireNonNull(modes, "No channel modes specified");
        this.sftp = Objects.requireNonNull(sftp, "No SFTP client instance");
        this.closeOnExit = closeOnExit;
        this.handle = sftp.open(path, modes);
    }

    public String getRemotePath() {
        return this.path;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return (int)this.doRead(Collections.singletonList(dst), -1L);
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("read(" + this.getRemotePath() + ") illegal position to read from: " + position);
        }
        return (int)this.doRead(Collections.singletonList(dst), position);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        List<ByteBuffer> buffers = Arrays.asList(dsts).subList(offset, offset + length);
        return this.doRead(buffers, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long doRead(List<ByteBuffer> buffers, long position) throws IOException {
        this.ensureOpen(READ_MODES);
        Object object = this.lock;
        synchronized (object) {
            boolean completed = false;
            boolean eof = false;
            long curPos = position >= 0L ? position : this.posTracker.get();
            try {
                long totalRead = 0L;
                this.beginBlocking();
                block7: for (ByteBuffer buffer : buffers) {
                    while (buffer.remaining() > 0) {
                        int read;
                        ByteBuffer wrap = buffer;
                        if (!buffer.hasArray()) {
                            wrap = ByteBuffer.allocate(Math.min(8192, buffer.remaining()));
                        }
                        if ((read = this.sftp.read(this.handle, curPos, wrap.array(), wrap.arrayOffset() + wrap.position(), wrap.remaining())) > 0) {
                            if (wrap == buffer) {
                                wrap.position(wrap.position() + read);
                            } else {
                                buffer.put(wrap.array(), wrap.arrayOffset(), read);
                            }
                            curPos += (long)read;
                            totalRead += (long)read;
                            continue;
                        }
                        eof = read == -1;
                        break block7;
                    }
                }
                completed = true;
                if (totalRead > 0L) {
                    long l = totalRead;
                    return l;
                }
                if (eof) {
                    long l = -1L;
                    return l;
                }
                long l = 0L;
                return l;
            }
            finally {
                if (position < 0L) {
                    this.posTracker.set(curPos);
                }
                this.endBlocking(completed);
            }
        }
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return (int)this.doWrite(Collections.singletonList(src), -1L);
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("write(" + this.getRemotePath() + ") illegal position to write to: " + position);
        }
        return (int)this.doWrite(Collections.singletonList(src), position);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        List<ByteBuffer> buffers = Arrays.asList(srcs).subList(offset, offset + length);
        return this.doWrite(buffers, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long doWrite(List<ByteBuffer> buffers, long position) throws IOException {
        this.ensureOpen(WRITE_MODES);
        Object object = this.lock;
        synchronized (object) {
            long l;
            boolean completed;
            block11: {
                completed = false;
                long curPos = position >= 0L ? position : this.posTracker.get();
                try {
                    long totalWritten = 0L;
                    this.beginBlocking();
                    for (ByteBuffer buffer : buffers) {
                        while (buffer.remaining() > 0) {
                            ByteBuffer wrap = buffer;
                            if (!buffer.hasArray()) {
                                wrap = ByteBuffer.allocate(Math.min(8192, buffer.remaining()));
                                buffer.get(wrap.array(), wrap.arrayOffset(), wrap.remaining());
                            }
                            int written = wrap.remaining();
                            this.sftp.write(this.handle, curPos, wrap.array(), wrap.arrayOffset() + wrap.position(), written);
                            if (wrap == buffer) {
                                wrap.position(wrap.position() + written);
                            }
                            curPos += (long)written;
                            totalWritten += (long)written;
                        }
                    }
                    completed = true;
                    l = totalWritten;
                    if (position >= 0L) break block11;
                    this.posTracker.set(curPos);
                }
                catch (Throwable throwable) {
                    if (position < 0L) {
                        this.posTracker.set(curPos);
                    }
                    this.endBlocking(completed);
                    throw throwable;
                }
            }
            this.endBlocking(completed);
            return l;
        }
    }

    @Override
    public long position() throws IOException {
        this.ensureOpen(Collections.emptySet());
        return this.posTracker.get();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("position(" + this.getRemotePath() + ") illegal file channel position: " + newPosition);
        }
        this.ensureOpen(Collections.emptySet());
        this.posTracker.set(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        this.ensureOpen(Collections.emptySet());
        return this.sftp.stat(this.handle).getSize();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        this.ensureOpen(Collections.emptySet());
        this.sftp.setStat(this.handle, new SftpClient.Attributes().size(size));
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.ensureOpen(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("transferTo(" + this.getRemotePath() + ") illegal position (" + position + ") or count (" + count + ")");
        }
        this.ensureOpen(READ_MODES);
        Object object = this.lock;
        synchronized (object) {
            long l;
            boolean completed = false;
            boolean eof = false;
            long curPos = position;
            try {
                this.beginBlocking();
                int bufSize = (int)Math.min(count, 32768L);
                byte[] buffer = new byte[bufSize];
                long totalRead = 0L;
                while (totalRead < count) {
                    int read = this.sftp.read(this.handle, curPos, buffer, 0, buffer.length);
                    if (read > 0) {
                        ByteBuffer wrap = ByteBuffer.wrap(buffer);
                        while (wrap.remaining() > 0) {
                            target.write(wrap);
                        }
                        curPos += (long)read;
                        totalRead += (long)read;
                        continue;
                    }
                    eof = read == -1;
                }
                completed = true;
                l = totalRead > 0L ? totalRead : (eof ? -1L : 0L);
            }
            catch (Throwable throwable) {
                this.endBlocking(completed);
                throw throwable;
            }
            this.endBlocking(completed);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        if (position < 0L || count < 0L) {
            throw new IllegalArgumentException("transferFrom(" + this.getRemotePath() + ") illegal position (" + position + ") or count (" + count + ")");
        }
        this.ensureOpen(WRITE_MODES);
        int copySize = this.sftp.getClientSession().getIntProperty(COPY_BUFSIZE_PROP, 8192);
        boolean completed = false;
        long curPos = position >= 0L ? position : this.posTracker.get();
        byte[] buffer = new byte[(int)Math.min((long)copySize, count)];
        Object object = this.lock;
        synchronized (object) {
            long l;
            try {
                ByteBuffer wrap;
                long totalRead;
                int read;
                this.beginBlocking();
                for (totalRead = 0L; totalRead < count && (read = src.read(wrap = ByteBuffer.wrap(buffer, 0, (int)Math.min((long)buffer.length, count - totalRead)))) > 0; totalRead += (long)read) {
                    this.sftp.write(this.handle, curPos, buffer, 0, read);
                    curPos += (long)read;
                }
                completed = true;
                l = totalRead;
            }
            catch (Throwable throwable) {
                this.endBlocking(completed);
                throw throwable;
            }
            this.endBlocking(completed);
            return l;
        }
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException("map(" + this.getRemotePath() + ")[" + mode + "," + position + "," + size + "] N/A");
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        return this.tryLock(position, size, shared);
    }

    @Override
    public FileLock tryLock(final long position, final long size, boolean shared) throws IOException {
        this.ensureOpen(Collections.emptySet());
        try {
            this.sftp.lock(this.handle, position, size, 0);
        }
        catch (SftpException e) {
            if (e.getStatus() == 17) {
                throw new OverlappingFileLockException();
            }
            throw e;
        }
        return new FileLock(this, position, size, shared){
            private final AtomicBoolean valid;
            {
                super(x0, x1, x2, x3);
                this.valid = new AtomicBoolean(true);
            }

            @Override
            public boolean isValid() {
                return this.acquiredBy().isOpen() && this.valid.get();
            }

            @Override
            public void release() throws IOException {
                if (this.valid.compareAndSet(true, false)) {
                    SftpRemotePathChannel.this.sftp.unlock(SftpRemotePathChannel.this.handle, position, size);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void implCloseChannel() throws IOException {
        try {
            Thread thread = this.blockingThreadHolder.get();
            if (thread != null) {
                thread.interrupt();
            }
        }
        finally {
            try {
                this.handle.close();
            }
            finally {
                if (this.closeOnExit) {
                    this.sftp.close();
                }
            }
        }
    }

    private void beginBlocking() {
        this.begin();
        this.blockingThreadHolder.set(Thread.currentThread());
    }

    private void endBlocking(boolean completed) throws AsynchronousCloseException {
        this.blockingThreadHolder.set(null);
        this.end(completed);
    }

    private void ensureOpen(Collection<SftpClient.OpenMode> reqModes) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (GenericUtils.size(reqModes) > 0) {
            for (SftpClient.OpenMode m : reqModes) {
                if (!this.modes.contains((Object)m)) continue;
                return;
            }
            throw new IOException("ensureOpen(" + this.getRemotePath() + ") current channel modes (" + this.modes + ") do contain any of the required: " + reqModes);
        }
    }

    public String toString() {
        return this.getRemotePath();
    }
}

