/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security.bouncycastle;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ReflectionUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.AbstractSecurityProviderRegistrar;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Signature;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class BouncyCastleSecurityProviderRegistrar
extends AbstractSecurityProviderRegistrar {
    public static final String PROVIDER_CLASS = "io.jenkins.cli.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider";
    private final AtomicReference<Boolean> supportHolder = new AtomicReference<Object>(null);
    private final AtomicReference<String> allSupportHolder = new AtomicReference();

    public BouncyCastleSecurityProviderRegistrar() {
        super("BC");
    }

    @Override
    public boolean isEnabled() {
        if (!super.isEnabled()) {
            return false;
        }
        return this.getBooleanProperty("io.jenkins.cli.shaded.org.apache.sshd.registerBouncyCastle", true);
    }

    @Override
    public Provider getSecurityProvider() {
        try {
            return this.getOrCreateProvider(PROVIDER_CLASS);
        }
        catch (ReflectiveOperationException t) {
            Throwable e = GenericUtils.peelException(t);
            this.log.error("getSecurityProvider({}) failed ({}) to instantiate {}: {}", this.getName(), e.getClass().getSimpleName(), PROVIDER_CLASS, e.getMessage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getDefaultSecurityEntitySupportValue(Class<?> entityType) {
        String allValue = this.allSupportHolder.get();
        if (GenericUtils.length(allValue) > 0) {
            return allValue;
        }
        String propName = this.getConfigurationPropertyName("supportAll");
        allValue = this.getStringProperty(propName, "all");
        if (GenericUtils.isEmpty(allValue)) {
            allValue = "none";
        }
        this.allSupportHolder.set(allValue);
        return allValue;
    }

    @Override
    public boolean isSecurityEntitySupported(Class<?> entityType, String name) {
        if (!this.isSupported()) {
            return false;
        }
        if (KeyPairGenerator.class.isAssignableFrom(entityType) || KeyFactory.class.isAssignableFrom(entityType) ? Objects.compare(name, "EdDSA", String.CASE_INSENSITIVE_ORDER) == 0 : Signature.class.isAssignableFrom(entityType) && Objects.compare(name, "NONEwithEdDSA", String.CASE_INSENSITIVE_ORDER) == 0) {
            return false;
        }
        return super.isSecurityEntitySupported(entityType, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupported() {
        Boolean supported;
        AtomicReference<Boolean> atomicReference = this.supportHolder;
        synchronized (atomicReference) {
            supported = this.supportHolder.get();
            if (supported != null) {
                return supported;
            }
            ClassLoader cl = ThreadUtils.resolveDefaultClassLoader(this.getClass());
            supported = ReflectionUtils.isClassAvailable(cl, PROVIDER_CLASS);
            this.supportHolder.set(supported);
        }
        return supported;
    }
}

