/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.scp;

import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.scp.ScpTimestamp;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface ScpClient
extends SessionHolder<ClientSession>,
ClientSessionHolder {
    public static final String SCP_EXEC_CHANNEL_OPEN_TIMEOUT = "scp-exec-channel-open-timeout";
    public static final long DEFAULT_EXEC_CHANNEL_OPEN_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final String SCP_EXEC_CHANNEL_EXIT_STATUS_TIMEOUT = "scp-exec-channel-exit-status-timeout";
    public static final long DEFAULT_EXEC_CHANNEL_EXIT_STATUS_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);

    default public void download(String remote, String local, Option ... options) throws IOException {
        this.download(remote, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String var1, String var2, Collection<Option> var3) throws IOException;

    default public void download(String remote, Path local, Option ... options) throws IOException {
        this.download(remote, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String var1, Path var2, Collection<Option> var3) throws IOException;

    public void download(String var1, OutputStream var2) throws IOException;

    default public byte[] downloadBytes(String remote) throws IOException {
        try (ByteArrayOutputStream local = new ByteArrayOutputStream();){
            this.download(remote, local);
            byte[] byArray = local.toByteArray();
            return byArray;
        }
    }

    default public void download(String[] remote, String local, Option ... options) throws IOException {
        this.download(remote, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void download(String[] remote, Path local, Option ... options) throws IOException {
        this.download(remote, local, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void download(String[] var1, String var2, Collection<Option> var3) throws IOException;

    public void download(String[] var1, Path var2, Collection<Option> var3) throws IOException;

    default public void upload(String local, String remote, Option ... options) throws IOException {
        this.upload(local, remote, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void upload(String local, String remote, Collection<Option> options) throws IOException {
        this.upload(new String[]{ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", (Object)local)}, remote, options);
    }

    default public void upload(Path local, String remote, Option ... options) throws IOException {
        this.upload(local, remote, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    default public void upload(Path local, String remote, Collection<Option> options) throws IOException {
        this.upload(new Path[]{ValidateUtils.checkNotNull(local, "Invalid local argument: %s", (Object)local)}, remote, GenericUtils.of(options));
    }

    default public void upload(String[] local, String remote, Option ... options) throws IOException {
        this.upload(local, remote, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void upload(String[] var1, String var2, Collection<Option> var3) throws IOException;

    default public void upload(Path[] local, String remote, Option ... options) throws IOException {
        this.upload(local, remote, (Collection<Option>)GenericUtils.of((Enum[])options));
    }

    public void upload(Path[] var1, String var2, Collection<Option> var3) throws IOException;

    default public void upload(byte[] data, String remote, Collection<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        this.upload(data, 0, data.length, remote, perms, time);
    }

    default public void upload(byte[] data, int offset, int len, String remote, Collection<PosixFilePermission> perms, ScpTimestamp time) throws IOException {
        try (ByteArrayInputStream local = new ByteArrayInputStream(data, offset, len);){
            this.upload(local, remote, len, perms, time);
        }
    }

    public void upload(InputStream var1, String var2, long var3, Collection<PosixFilePermission> var5, ScpTimestamp var6) throws IOException;

    public static String createSendCommand(String remote, Collection<Option> options) {
        StringBuilder sb = new StringBuilder(remote.length() + 64).append("scp");
        if (options.contains((Object)Option.Recursive)) {
            sb.append(" -r");
        }
        if (options.contains((Object)Option.TargetIsDirectory)) {
            sb.append(" -d");
        }
        if (options.contains((Object)Option.PreserveAttributes)) {
            sb.append(" -p");
        }
        sb.append(" -t").append(" --").append(" ").append(remote);
        return sb.toString();
    }

    public static String createReceiveCommand(String remote, Collection<Option> options) {
        ValidateUtils.checkNotNullAndNotEmpty(remote, "No remote location specified");
        StringBuilder sb = new StringBuilder(remote.length() + 64).append("scp");
        if (options.contains((Object)Option.Recursive)) {
            sb.append(" -r");
        }
        if (options.contains((Object)Option.PreserveAttributes)) {
            sb.append(" -p");
        }
        sb.append(" -f").append(" --").append(' ').append(remote);
        return sb.toString();
    }

    public static enum Option {
        Recursive,
        PreserveAttributes,
        TargetIsDirectory;

    }
}

