/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import io.jenkins.cli.shaded.org.apache.sshd.server.subsystem.sftp.DirectoryHandle;
import io.jenkins.cli.shaded.org.apache.sshd.server.subsystem.sftp.FileHandle;
import io.jenkins.cli.shaded.org.apache.sshd.server.subsystem.sftp.Handle;
import io.jenkins.cli.shaded.org.apache.sshd.server.subsystem.sftp.SftpEventListener;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public abstract class AbstractSftpEventListenerAdapter
extends AbstractLoggingBean
implements SftpEventListener {
    protected AbstractSftpEventListenerAdapter() {
    }

    @Override
    public void initialized(ServerSession session, int version) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("initialized(" + session + ") version: " + version);
        }
    }

    @Override
    public void destroying(ServerSession session) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("destroying(" + session + ")");
        }
    }

    @Override
    public void opening(ServerSession session, String remoteHandle, Handle localHandle) throws IOException {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("opening(" + session + ")[" + remoteHandle + "] " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file") + " " + path);
        }
    }

    @Override
    public void open(ServerSession session, String remoteHandle, Handle localHandle) {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("open(" + session + ")[" + remoteHandle + "] " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file") + " " + path);
        }
    }

    @Override
    public void read(ServerSession session, String remoteHandle, DirectoryHandle localHandle, Map<String, Path> entries) throws IOException {
        int numEntries = GenericUtils.size(entries);
        if (this.log.isDebugEnabled()) {
            this.log.debug("read(" + session + ")[" + localHandle.getFile() + "] " + numEntries + " entries");
        }
        if (numEntries > 0 && this.log.isTraceEnabled()) {
            entries.forEach((key, value) -> this.log.trace("read(" + session + ")[" + localHandle.getFile() + "] " + key + " - " + value));
        }
    }

    @Override
    public void reading(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("reading(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", requested=" + dataLen);
        }
    }

    @Override
    public void read(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, int readLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("read(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", requested=" + dataLen + ", read=" + readLen + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void writing(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("write(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", requested=" + dataLen);
        }
    }

    @Override
    public void written(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, byte[] data, int dataOffset, int dataLen, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("written(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", requested=" + dataLen + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void blocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocking(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask));
        }
    }

    @Override
    public void blocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, int mask, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("blocked(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", length=" + length + ", mask=0x" + Integer.toHexString(mask) + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void unblocking(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocking(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", length=" + length);
        }
    }

    @Override
    public void unblocked(ServerSession session, String remoteHandle, FileHandle localHandle, long offset, long length, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("unblocked(" + session + ")[" + localHandle.getFile() + "] offset=" + offset + ", length=" + length + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void close(ServerSession session, String remoteHandle, Handle localHandle) {
        if (this.log.isTraceEnabled()) {
            Path path = localHandle.getFile();
            this.log.trace("close(" + session + ")[" + remoteHandle + "] " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file") + " " + path);
        }
    }

    @Override
    public void creating(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("creating(" + session + ") " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file") + " " + path);
        }
    }

    @Override
    public void created(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("created(" + session + ") " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file") + " " + path + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void moving(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moving(" + session + ")[" + opts + "]" + srcPath + " => " + dstPath);
        }
    }

    @Override
    public void moved(ServerSession session, Path srcPath, Path dstPath, Collection<CopyOption> opts, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("moved(" + session + ")[" + opts + "]" + srcPath + " => " + dstPath + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void removing(ServerSession session, Path path) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removing(" + session + ") " + path);
        }
    }

    @Override
    public void removed(ServerSession session, Path path, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("removed(" + session + ") " + path + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void linking(ServerSession session, Path source, Path target, boolean symLink) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linking(" + session + ")[" + symLink + "]" + source + " => " + target);
        }
    }

    @Override
    public void linked(ServerSession session, Path source, Path target, boolean symLink, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("linked(" + session + ")[" + symLink + "]" + source + " => " + target + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }

    @Override
    public void modifyingAttributes(ServerSession session, Path path, Map<String, ?> attrs) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifyingAttributes(" + session + ") " + path + ": " + attrs);
        }
    }

    @Override
    public void modifiedAttributes(ServerSession session, Path path, Map<String, ?> attrs, Throwable thrown) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("modifiedAttributes(" + session + ") " + path + (thrown == null ? "" : ": " + thrown.getClass().getSimpleName() + ": " + thrown.getMessage()));
        }
    }
}

