/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpDirEntryIterator;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.IOException;
import java.util.Objects;

public class SftpIterableDirEntry
implements Iterable<SftpClient.DirEntry> {
    private final SftpClient client;
    private final String path;

    public SftpIterableDirEntry(SftpClient client, String path) {
        this.client = Objects.requireNonNull(client, "No client instance");
        this.path = ValidateUtils.checkNotNullAndNotEmpty(path, "No remote path");
    }

    public final SftpClient getClient() {
        return this.client;
    }

    public final String getPath() {
        return this.path;
    }

    public SftpDirEntryIterator iterator() {
        try {
            return new SftpDirEntryIterator(this.getClient(), this.getPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

