/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractKeyPairResourceParser
extends AbstractLoggingBean
implements KeyPairResourceParser {
    private final List<String> beginners;
    private final List<String> enders;
    private final List<List<String>> endingMarkers;

    protected AbstractKeyPairResourceParser(List<String> beginners, List<String> enders) {
        this.beginners = ValidateUtils.checkNotNullAndNotEmpty(beginners, "No begin markers", new Object[0]);
        this.enders = ValidateUtils.checkNotNullAndNotEmpty(enders, "No end markers", new Object[0]);
        ValidateUtils.checkTrue(beginners.size() == enders.size(), "Mismatched begin(%d)/end(%d) markers sizes", beginners.size(), enders.size());
        this.endingMarkers = new ArrayList<List<String>>(enders.size());
        enders.forEach(m -> this.endingMarkers.add(Collections.singletonList(m)));
    }

    public List<String> getBeginners() {
        return this.beginners;
    }

    public List<String> getEnders() {
        return this.enders;
    }

    public List<List<String>> getEndingMarkers() {
        return this.endingMarkers;
    }

    @Override
    public boolean canExtractKeyPairs(String resourceKey, List<String> lines) throws IOException, GeneralSecurityException {
        return KeyPairResourceParser.containsMarkerLine(lines, this.getBeginners());
    }

    @Override
    public Collection<KeyPair> loadKeyPairs(String resourceKey, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        List<KeyPair> keyPairs = Collections.emptyList();
        List<String> beginMarkers = this.getBeginners();
        List<List<String>> endMarkers = this.getEndingMarkers();
        AbstractMap.SimpleImmutableEntry<Integer, Integer> markerPos = KeyPairResourceParser.findMarkerLine(lines, beginMarkers);
        while (markerPos != null) {
            int startIndex = (Integer)markerPos.getKey();
            String startLine = lines.get(startIndex);
            int markerIndex = (Integer)markerPos.getValue();
            List<String> ender = endMarkers.get(markerIndex);
            if ((markerPos = KeyPairResourceParser.findMarkerLine(lines, ++startIndex, ender)) == null) {
                throw new StreamCorruptedException("Missing end marker (" + ender + ") after line #" + startIndex);
            }
            int endIndex = (Integer)markerPos.getKey();
            String endLine = lines.get(endIndex);
            Collection<KeyPair> kps = this.extractKeyPairs(resourceKey, startLine, endLine, passwordProvider, lines.subList(startIndex, endIndex));
            if (GenericUtils.isNotEmpty(kps)) {
                if (GenericUtils.isEmpty(keyPairs)) {
                    keyPairs = new LinkedList<KeyPair>(kps);
                } else {
                    keyPairs.addAll(kps);
                }
            }
            markerPos = KeyPairResourceParser.findMarkerLine(lines, endIndex + 1, beginMarkers);
        }
        return keyPairs;
    }

    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, List<String> lines) throws IOException, GeneralSecurityException {
        return this.extractKeyPairs(resourceKey, beginMarker, endMarker, passwordProvider, KeyPairResourceParser.extractDataBytes(lines));
    }

    public Collection<KeyPair> extractKeyPairs(String resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, byte[] bytes) throws IOException, GeneralSecurityException {
        if (this.log.isTraceEnabled()) {
            BufferUtils.dumpHex(this.getSimplifiedLogger(), Level.FINER, beginMarker, ':', 16, bytes);
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
            Collection<KeyPair> collection = this.extractKeyPairs(resourceKey, beginMarker, endMarker, passwordProvider, bais);
            return collection;
        }
    }

    public abstract Collection<KeyPair> extractKeyPairs(String var1, String var2, String var3, FilePasswordProvider var4, InputStream var5) throws IOException, GeneralSecurityException;
}

