/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import java.io.IOException;
import java.nio.file.FileSystem;

public interface SftpClientCreator {
    default public SftpClient createSftpClient() throws IOException {
        return this.createSftpClient(SftpVersionSelector.CURRENT);
    }

    default public SftpClient createSftpClient(int version) throws IOException {
        return this.createSftpClient(SftpVersionSelector.fixedVersionSelector(version));
    }

    public SftpClient createSftpClient(SftpVersionSelector var1) throws IOException;

    default public FileSystem createSftpFileSystem() throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.CURRENT);
    }

    default public FileSystem createSftpFileSystem(int version) throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.fixedVersionSelector(version));
    }

    default public FileSystem createSftpFileSystem(SftpVersionSelector selector) throws IOException {
        return this.createSftpFileSystem(selector, 32768, 32768);
    }

    default public FileSystem createSftpFileSystem(int version, int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.fixedVersionSelector(version), readBufferSize, writeBufferSize);
    }

    default public FileSystem createSftpFileSystem(int readBufferSize, int writeBufferSize) throws IOException {
        return this.createSftpFileSystem(SftpVersionSelector.CURRENT, readBufferSize, writeBufferSize);
    }

    public FileSystem createSftpFileSystem(SftpVersionSelector var1, int var2, int var3) throws IOException;
}

