/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.future;

import io.jenkins.cli.shaded.org.apache.sshd.common.future.AbstractSshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFutureListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.io.InterruptedIOException;
import java.lang.reflect.Array;
import java.util.Objects;

public class DefaultSshFuture<T extends SshFuture>
extends AbstractSshFuture<T> {
    private final Object lock;
    private Object listeners;
    private Object result;

    public DefaultSshFuture(Object id, Object lock) {
        super(id);
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object await0(long timeoutMillis, boolean interruptable) throws InterruptedIOException {
        long startTime;
        ValidateUtils.checkTrue(timeoutMillis >= 0L, "Negative timeout N/A: %d", timeoutMillis);
        long curTime = startTime = System.currentTimeMillis();
        long endTime = Long.MAX_VALUE - timeoutMillis < curTime ? Long.MAX_VALUE : curTime + timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null || timeoutMillis <= 0L) {
                return this.result;
            }
            do {
                block7: {
                    try {
                        this.lock.wait(endTime - curTime);
                    }
                    catch (InterruptedException e) {
                        if (!interruptable) break block7;
                        curTime = System.currentTimeMillis();
                        throw (InterruptedIOException)new InterruptedIOException("Interrupted after " + (curTime - startTime) + " msec.").initCause(e);
                    }
                }
                curTime = System.currentTimeMillis();
            } while (this.result == null && curTime < endTime);
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.result != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return;
            }
            this.result = newValue != null ? newValue : GenericUtils.NULL;
            this.lock.notifyAll();
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumRegisteredListeners() {
        Object object = this.lock;
        synchronized (object) {
            if (this.listeners == null) {
                return 0;
            }
            if (this.listeners instanceof SshFutureListener) {
                return 1;
            }
            int l = Array.getLength(this.listeners);
            int count = 0;
            for (int i = 0; i < l; ++i) {
                if (Array.get(this.listeners, i) == null) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result == GenericUtils.NULL ? null : this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(SshFutureListener<T> listener) {
        Objects.requireNonNull(listener, "Missing listener argument");
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                notifyNow = true;
            } else if (this.listeners == null) {
                this.listeners = listener;
            } else if (this.listeners instanceof SshFutureListener) {
                this.listeners = new Object[]{this.listeners, listener};
            } else {
                Object[] ol = (Object[])this.listeners;
                int l = ol.length;
                Object[] nl = new Object[l + 1];
                System.arraycopy(ol, 0, nl, 0, l);
                nl[l] = listener;
                this.listeners = nl;
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return this.asT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(SshFutureListener<T> listener) {
        Objects.requireNonNull(listener, "No listener provided");
        Object object = this.lock;
        synchronized (object) {
            if (this.result != null) {
                return this.asT();
            }
            if (this.listeners == null) {
                return this.asT();
            }
            if (this.listeners == listener) {
                this.listeners = null;
            } else if (!(this.listeners instanceof SshFutureListener)) {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    if (Array.get(this.listeners, i) != listener) continue;
                    Array.set(this.listeners, i, null);
                    break;
                }
            }
        }
        return this.asT();
    }

    protected void notifyListeners() {
        if (this.listeners != null) {
            if (this.listeners instanceof SshFutureListener) {
                this.notifyListener(this.asListener(this.listeners));
            } else {
                int l = Array.getLength(this.listeners);
                for (int i = 0; i < l; ++i) {
                    SshFutureListener listener = this.asListener(Array.get(this.listeners, i));
                    if (listener == null) continue;
                    this.notifyListener(listener);
                }
            }
        }
    }

    public boolean isCanceled() {
        return this.getValue() == CANCELED;
    }

    public void cancel() {
        this.setValue(CANCELED);
    }

    @Override
    public String toString() {
        return super.toString() + "[value=" + this.result + "]";
    }
}

