/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.scp;

import io.jenkins.cli.shaded.org.apache.sshd.common.scp.ScpFileOpener;
import io.jenkins.cli.shaded.org.apache.sshd.common.scp.ScpFileOpenerHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.scp.ScpTransferEventListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.EventListenerUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ObjectBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import io.jenkins.cli.shaded.org.apache.sshd.server.Command;
import io.jenkins.cli.shaded.org.apache.sshd.server.CommandFactory;
import io.jenkins.cli.shaded.org.apache.sshd.server.scp.ScpCommand;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;

public class ScpCommandFactory
implements ScpFileOpenerHolder,
CommandFactory,
Cloneable,
ExecutorServiceConfigurer {
    private CommandFactory delegate;
    private ExecutorService executors;
    private boolean shutdownExecutor;
    private ScpFileOpener fileOpener;
    private int sendBufferSize = 127;
    private int receiveBufferSize = 127;
    private Collection<ScpTransferEventListener> listeners = new CopyOnWriteArraySet<ScpTransferEventListener>();
    private ScpTransferEventListener listenerProxy = EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, this.getClass().getClassLoader(), this.listeners);

    @Override
    public ScpFileOpener getScpFileOpener() {
        return this.fileOpener;
    }

    @Override
    public void setScpFileOpener(ScpFileOpener fileOpener) {
        this.fileOpener = fileOpener;
    }

    public CommandFactory getDelegateCommandFactory() {
        return this.delegate;
    }

    public void setDelegateCommandFactory(CommandFactory factory) {
        this.delegate = factory;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executors;
    }

    @Override
    public void setExecutorService(ExecutorService service) {
        this.executors = service;
    }

    @Override
    public boolean isShutdownOnExit() {
        return this.shutdownExecutor;
    }

    @Override
    public void setShutdownOnExit(boolean shutdown) {
        this.shutdownExecutor = shutdown;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendSize) {
        if (sendSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() send buffer size (" + sendSize + ") below minimum required (" + 127 + ")");
        }
        this.sendBufferSize = sendSize;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveSize) {
        if (receiveSize < 127) {
            throw new IllegalArgumentException("<ScpCommandFactory>() receive buffer size (" + receiveSize + ") below minimum required (" + 127 + ")");
        }
        this.receiveBufferSize = receiveSize;
    }

    public boolean addEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.add(listener);
    }

    public boolean removeEventListener(ScpTransferEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("No listener instance");
        }
        return this.listeners.remove(listener);
    }

    @Override
    public Command createCommand(String command) {
        if (command.startsWith("scp")) {
            return new ScpCommand(command, this.getExecutorService(), this.isShutdownOnExit(), this.getSendBufferSize(), this.getReceiveBufferSize(), this.getScpFileOpener(), this.listenerProxy);
        }
        CommandFactory factory = this.getDelegateCommandFactory();
        if (factory != null) {
            return factory.createCommand(command);
        }
        throw new IllegalArgumentException("Unknown command, does not begin with 'scp': " + command);
    }

    public ScpCommandFactory clone() {
        try {
            ScpCommandFactory other = (ScpCommandFactory)this.getClass().cast(super.clone());
            other.listeners = new CopyOnWriteArraySet<ScpTransferEventListener>(this.listeners);
            other.listenerProxy = EventListenerUtils.proxyWrapper(ScpTransferEventListener.class, this.getClass().getClassLoader(), other.listeners);
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder
    implements ObjectBuilder<ScpCommandFactory> {
        private final ScpCommandFactory factory = new ScpCommandFactory();

        public Builder withFileOpener(ScpFileOpener opener) {
            this.factory.setScpFileOpener(opener);
            return this;
        }

        public Builder withDelegate(CommandFactory delegate) {
            this.factory.setDelegateCommandFactory(delegate);
            return this;
        }

        public Builder withExecutorService(ExecutorService service) {
            this.factory.setExecutorService(service);
            return this;
        }

        public Builder withShutdownOnExit(boolean shutdown) {
            this.factory.setShutdownOnExit(shutdown);
            return this;
        }

        public Builder withSendBufferSize(int sendSize) {
            this.factory.setSendBufferSize(sendSize);
            return this;
        }

        public Builder withReceiveBufferSize(int receiveSize) {
            this.factory.setReceiveBufferSize(receiveSize);
            return this;
        }

        public Builder addEventListener(ScpTransferEventListener listener) {
            this.factory.addEventListener(listener);
            return this;
        }

        public Builder removeEventListener(ScpTransferEventListener listener) {
            this.factory.removeEventListener(listener);
            return this;
        }

        @Override
        public ScpCommandFactory build() {
            return this.factory.clone();
        }
    }
}

