/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.VersionInfo;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class OsUtils {
    public static final String CURRENT_USER_OVERRIDE_PROP = "io.jenkins.cli.shaded.org.apache.sshd.currentUser";
    public static final String JAVA_VERSION_OVERRIDE_PROP = "io.jenkins.cli.shaded.org.apache.sshd.javaVersion";
    public static final String OS_TYPE_OVERRIDE_PROP = "io.jenkins.cli.shaded.org.apache.sshd.osType";
    public static final String WINDOWS_SHELL_COMMAND_NAME = "cmd.exe";
    public static final String LINUX_SHELL_COMMAND_NAME = "/bin/sh";
    public static final String ROOT_USER = "root";
    public static final List<String> LINUX_COMMAND = Collections.unmodifiableList(Arrays.asList("/bin/sh", "-i", "-l"));
    public static final List<String> WINDOWS_COMMAND = Collections.unmodifiableList(Collections.singletonList("cmd.exe"));
    private static final AtomicReference<String> CURRENT_USER_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<VersionInfo> JAVA_VERSION_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicReference<Boolean> OS_TYPE_HOLDER = new AtomicReference<Object>(null);

    private OsUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static boolean isUNIX() {
        return !OsUtils.isWin32();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWin32() {
        Boolean typeValue;
        AtomicReference<Boolean> atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            typeValue = OS_TYPE_HOLDER.get();
            if (typeValue != null) {
                return typeValue;
            }
            String value = System.getProperty(OS_TYPE_OVERRIDE_PROP, System.getProperty("os.name"));
            typeValue = GenericUtils.trimToEmpty(value).toLowerCase().contains("windows");
            OS_TYPE_HOLDER.set(typeValue);
        }
        return typeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWin32(Boolean win32) {
        AtomicReference<Boolean> atomicReference = OS_TYPE_HOLDER;
        synchronized (atomicReference) {
            OS_TYPE_HOLDER.set(win32);
        }
    }

    public static List<String> resolveDefaultInteractiveCommand() {
        return OsUtils.resolveInteractiveCommand(OsUtils.isWin32());
    }

    public static List<String> resolveInteractiveCommand(boolean isWin32) {
        if (isWin32) {
            return WINDOWS_COMMAND;
        }
        return LINUX_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentUser() {
        String username = null;
        AtomicReference<String> atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            username = CURRENT_USER_HOLDER.get();
            if (username != null) {
                return username;
            }
            username = OsUtils.getCanonicalUser(System.getProperty(CURRENT_USER_OVERRIDE_PROP, System.getProperty("user.name")));
            ValidateUtils.checkNotNullAndNotEmpty(username, "No username available");
            CURRENT_USER_HOLDER.set(username);
        }
        return username;
    }

    public static String getCanonicalUser(String user) {
        if (GenericUtils.isEmpty(user)) {
            return user;
        }
        if (OsUtils.isWin32()) {
            int pos = user.lastIndexOf(92);
            if (pos > 0) {
                user = user.substring(pos + 1);
            }
            if ((pos = user.indexOf(32)) > 0) {
                user = user.substring(0, pos).trim();
            }
        }
        return user;
    }

    public static String resolveCanonicalGroup(String group, String user) {
        if (OsUtils.isUNIX()) {
            return group;
        }
        if (GenericUtils.isEmpty(group)) {
            int pos = GenericUtils.isEmpty(user) ? -1 : user.lastIndexOf(92);
            return pos > 0 ? user.substring(0, pos) : group;
        }
        int pos = group.indexOf(32);
        return pos < 0 ? group : group.substring(0, pos).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentUser(String username) {
        AtomicReference<String> atomicReference = CURRENT_USER_HOLDER;
        synchronized (atomicReference) {
            CURRENT_USER_HOLDER.set(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionInfo getJavaVersion() {
        VersionInfo version;
        AtomicReference<VersionInfo> atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            version = JAVA_VERSION_HOLDER.get();
            if (version != null) {
                return version;
            }
            String value = System.getProperty(JAVA_VERSION_OVERRIDE_PROP, System.getProperty("java.version"));
            value = ValidateUtils.checkNotNullAndNotEmpty(value, "No configured Java version value").replace('_', '.');
            for (int index = 0; index < value.length(); ++index) {
                char ch = value.charAt(index);
                if (ch == '.' || ch >= '0' && ch <= '9') continue;
                value = value.substring(0, index);
                break;
            }
            version = ValidateUtils.checkNotNull(VersionInfo.parse(value), "No version parsed for %s", (Object)value);
            JAVA_VERSION_HOLDER.set(version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJavaVersion(VersionInfo version) {
        AtomicReference<VersionInfo> atomicReference = JAVA_VERSION_HOLDER;
        synchronized (atomicReference) {
            JAVA_VERSION_HOLDER.set(version);
        }
    }

    public static String getComparablePath(String path) {
        String p = path == null ? "" : path;
        return OsUtils.isWin32() ? p.toLowerCase() : p;
    }
}

