/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.client.future.OpenFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.AttributeStore;
import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelListenerManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.RequestHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.throttle.ChannelStreamPacketWriterResolverManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.PacketWriter;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public interface Channel
extends ChannelListenerManager,
PropertyResolver,
AttributeStore,
PacketWriter,
ChannelStreamPacketWriterResolverManager,
Closeable {
    public static final String CHANNEL_EXEC = "exec";
    public static final String CHANNEL_SHELL = "shell";
    public static final String CHANNEL_SUBSYSTEM = "subsystem";

    public int getId();

    public int getRecipient();

    public Session getSession();

    public Window getLocalWindow();

    public Window getRemoteWindow();

    public List<RequestHandler<Channel>> getRequestHandlers();

    public void addRequestHandler(RequestHandler<Channel> var1);

    default public void addRequestHandlers(Collection<? extends RequestHandler<Channel>> handlers) {
        GenericUtils.forEach(handlers, this::addRequestHandler);
    }

    public void removeRequestHandler(RequestHandler<Channel> var1);

    default public void removeRequestHandlers(Collection<? extends RequestHandler<Channel>> handlers) {
        GenericUtils.forEach(handlers, this::removeRequestHandler);
    }

    public void handleClose() throws IOException;

    public void handleWindowAdjust(Buffer var1) throws IOException;

    public void handleRequest(Buffer var1) throws IOException;

    public void handleData(Buffer var1) throws IOException;

    public void handleExtendedData(Buffer var1) throws IOException;

    public void handleEof() throws IOException;

    public void handleSuccess() throws IOException;

    public void handleFailure() throws IOException;

    public void init(ConnectionService var1, Session var2, int var3) throws IOException;

    public boolean isInitialized();

    public boolean isEofSignalled();

    public OpenFuture open(int var1, long var2, long var4, Buffer var6);

    public void handleOpenSuccess(int var1, long var2, long var4, Buffer var6) throws IOException;

    public void handleOpenFailure(Buffer var1) throws IOException;
}

