/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.LoggingUtils;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;

public interface KeyExchange
extends NamedResource {
    public static final Map<Integer, String> GROUP_KEX_OPCODES_MAP = Collections.unmodifiableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEX_DH_GEX_"));
    public static final Map<Integer, String> SIMPLE_KEX_OPCODES_MAP = Collections.unmodifiableMap(LoggingUtils.generateMnemonicMap(SshConstants.class, "SSH_MSG_KEXDH_"));

    public void init(Session var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5) throws Exception;

    public boolean next(int var1, Buffer var2) throws Exception;

    public Digest getHash();

    public byte[] getH();

    public byte[] getK();

    public PublicKey getServerKey();

    public static String getGroupKexOpcodeName(int cmd) {
        String name = GROUP_KEX_OPCODES_MAP.get(cmd);
        if (GenericUtils.isEmpty(name)) {
            return SshConstants.getCommandMessageName(cmd);
        }
        return name;
    }

    public static String getSimpleKexOpcodeName(int cmd) {
        String name = SIMPLE_KEX_OPCODES_MAP.get(cmd);
        if (GenericUtils.isEmpty(name)) {
            return SshConstants.getCommandMessageName(cmd);
        }
        return name;
    }
}

