/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.session;

import io.jenkins.cli.shaded.org.apache.sshd.agent.common.AgentForwardSupport;
import io.jenkins.cli.shaded.org.apache.sshd.client.ClientFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.AbstractClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSessionHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.AbstractIoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers.AbstractConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.server.x11.X11ForwardSupport;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientConnectionService
extends AbstractConnectionService<AbstractClientSession>
implements ClientSessionHolder {
    private ScheduledFuture<?> heartBeat;

    public ClientConnectionService(AbstractClientSession s) throws SshException {
        super(s);
    }

    @Override
    public final ClientSession getClientSession() {
        return (ClientSession)this.getSession();
    }

    @Override
    public void start() {
        ClientSession session = this.getClientSession();
        if (!session.isAuthenticated()) {
            throw new IllegalStateException("Session is not authenticated");
        }
        this.startHeartBeat();
    }

    @Override
    protected void preClose() {
        this.stopHeartBeat();
        super.preClose();
    }

    protected synchronized void startHeartBeat() {
        this.stopHeartBeat();
        ClientSession session = this.getClientSession();
        long interval = session.getLongProperty("heartbeat-interval", 0L);
        if (interval > 0L) {
            ClientFactoryManager manager = session.getFactoryManager();
            ScheduledExecutorService service = manager.getScheduledExecutorService();
            this.heartBeat = service.scheduleAtFixedRate(this::sendHeartBeat, interval, interval, TimeUnit.MILLISECONDS);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startHeartbeat - started at interval={}", (Object)interval);
            }
        }
    }

    protected synchronized void stopHeartBeat() {
        if (this.heartBeat != null) {
            this.heartBeat.cancel(true);
            this.heartBeat = null;
        }
    }

    protected IoWriteFuture sendHeartBeat() {
        ClientSession session = this.getClientSession();
        String request = session.getStringProperty("heartbeat-request", "keepalive@sshd.apache.org");
        try {
            Buffer buf = session.createBuffer((byte)80, request.length() + 8);
            buf.putString(request);
            buf.putBoolean(false);
            IoWriteFuture future = session.writePacket(buf);
            future.addListener(this::futureDone);
            return future;
        }
        catch (IOException e) {
            ((AbstractClientSession)this.getSession()).exceptionCaught(e);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Error (" + e.getClass().getSimpleName() + ") sending keepalive message=" + request + ": " + e.getMessage());
            }
            final IOException t = e;
            return new AbstractIoWriteFuture(request, null){
                {
                    super(id, lock);
                    this.setValue(t);
                }
            };
        }
    }

    protected void futureDone(IoWriteFuture future) {
        Throwable t = future.getException();
        if (t != null) {
            ((AbstractClientSession)this.getSession()).exceptionCaught(t);
        }
    }

    @Override
    public AgentForwardSupport getAgentForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }

    @Override
    public X11ForwardSupport getX11ForwardSupport() {
        throw new IllegalStateException("Server side operation");
    }
}

