/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io;

import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.AbstractIoServiceFactoryFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.BuiltinIoServiceFactoryFactories;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceFactoryFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ExecutorServiceConfigurer;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;

public class DefaultIoServiceFactoryFactory
extends AbstractIoServiceFactoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultIoServiceFactoryFactory.class);
    private IoServiceFactoryFactory factory;

    public DefaultIoServiceFactoryFactory() {
        this(null, true);
    }

    protected DefaultIoServiceFactoryFactory(ExecutorService executors, boolean shutdownOnExit) {
        super(executors, shutdownOnExit);
    }

    @Override
    public IoServiceFactory create(FactoryManager manager) {
        return this.getFactory().create(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoServiceFactoryFactory getFactory() {
        DefaultIoServiceFactoryFactory defaultIoServiceFactoryFactory = this;
        synchronized (defaultIoServiceFactoryFactory) {
            if (this.factory == null) {
                this.factory = DefaultIoServiceFactoryFactory.newInstance(IoServiceFactoryFactory.class);
                if (this.factory instanceof ExecutorServiceConfigurer) {
                    ExecutorServiceConfigurer configurer = (ExecutorServiceConfigurer)((Object)this.factory);
                    configurer.setExecutorService(this.getExecutorService());
                    configurer.setShutdownOnExit(this.isShutdownOnExit());
                }
            }
        }
        return this.factory;
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<T> clazz) {
        T t;
        String factory = System.getProperty(clazz.getName());
        if (!GenericUtils.isEmpty(factory)) {
            return DefaultIoServiceFactoryFactory.newInstance(clazz, factory);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && (t = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, cl))) != null) {
            return t;
        }
        if (cl != DefaultIoServiceFactoryFactory.class.getClassLoader() && (t = DefaultIoServiceFactoryFactory.tryLoad(ServiceLoader.load(clazz, DefaultIoServiceFactoryFactory.class.getClassLoader()))) != null) {
            return t;
        }
        throw new IllegalStateException("Could not find a valid sshd io provider");
    }

    public static <T extends IoServiceFactoryFactory> T tryLoad(ServiceLoader<T> loader) {
        Iterator<T> it = loader.iterator();
        try {
            while (it.hasNext()) {
                try {
                    return (T)((IoServiceFactoryFactory)it.next());
                }
                catch (Throwable t) {
                    LOGGER.trace("Exception while loading factory from ServiceLoader", t);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.trace("Exception while loading factory from ServiceLoader", t);
        }
        return null;
    }

    public static <T extends IoServiceFactoryFactory> T newInstance(Class<T> clazz, String factory) {
        BuiltinIoServiceFactoryFactories builtin = BuiltinIoServiceFactoryFactories.fromFactoryName(factory);
        if (builtin != null) {
            return (T)((IoServiceFactoryFactory)clazz.cast(builtin.create()));
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            try {
                return (T)((IoServiceFactoryFactory)clazz.cast(cl.loadClass(factory).newInstance()));
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        if (cl != DefaultIoServiceFactoryFactory.class.getClassLoader()) {
            try {
                return (T)((IoServiceFactoryFactory)clazz.cast(DefaultIoServiceFactoryFactory.class.getClassLoader().loadClass(factory).newInstance()));
            }
            catch (Throwable t) {
                LOGGER.trace("Exception while loading factory " + factory, t);
            }
        }
        throw new IllegalStateException("Unable to create instance of class " + factory);
    }
}

