/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.threads;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class ThreadUtils {
    private ThreadUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static ExecutorService protectExecutorServiceShutdown(final ExecutorService executorService, boolean shutdownOnExit) {
        if (executorService == null || shutdownOnExit) {
            return executorService;
        }
        return (ExecutorService)Proxy.newProxyInstance(ThreadUtils.resolveDefaultClassLoader(executorService), new Class[]{ExecutorService.class}, new InvocationHandler(){
            private final AtomicBoolean stopped = new AtomicBoolean(false);

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String name = method.getName();
                if ("isShutdown".equals(name)) {
                    return this.stopped.get();
                }
                if ("shutdown".equals(name)) {
                    this.stopped.set(true);
                    return null;
                }
                if ("shutdownNow".equals(name)) {
                    this.stopped.set(true);
                    return Collections.emptyList();
                }
                return method.invoke((Object)executorService, args);
            }
        });
    }

    public static ClassLoader resolveDefaultClassLoader(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoader(anchor == null ? null : anchor.getClass());
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Object anchor) {
        return ThreadUtils.resolveDefaultClassLoaders(anchor == null ? null : anchor.getClass());
    }

    public static <T> T createDefaultInstance(Class<?> anchor, Class<T> targetType, String className) throws ReflectiveOperationException {
        return ThreadUtils.createDefaultInstance(ThreadUtils.resolveDefaultClassLoaders(anchor), targetType, className);
    }

    public static <T> T createDefaultInstance(ClassLoader cl, Class<T> targetType, String className) throws ReflectiveOperationException {
        Class<?> instanceType = cl.loadClass(className);
        Object instance = instanceType.newInstance();
        return targetType.cast(instance);
    }

    public static <T> T createDefaultInstance(Iterable<ClassLoader> cls, Class<T> targetType, String className) throws ReflectiveOperationException {
        for (ClassLoader cl : cls) {
            try {
                return ThreadUtils.createDefaultInstance(cl, targetType, className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    public static ClassLoader resolveDefaultClassLoader(Class<?> anchor) {
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl != null) {
            return cl;
        }
        if (anchor != null) {
            cl = anchor.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static Iterable<ClassLoader> resolveDefaultClassLoaders(Class<?> anchor) {
        LinkedHashSet<ClassLoader> cls = new LinkedHashSet<ClassLoader>();
        Thread thread = Thread.currentThread();
        ClassLoader cl = thread.getContextClassLoader();
        if (cl != null) {
            cls.add(cl);
        }
        if (anchor != null) {
            cls.add(anchor.getClassLoader());
        }
        cls.add(ClassLoader.getSystemClassLoader());
        return cls;
    }

    public static ExecutorService newFixedThreadPool(String poolName, int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService newCachedThreadPool(String poolName) {
        return new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new SshdThreadFactory(poolName), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        return new ScheduledThreadPoolExecutor(1, new SshdThreadFactory(poolName));
    }

    public static ExecutorService newSingleThreadExecutor(String poolName) {
        return ThreadUtils.newFixedThreadPool(poolName, 1);
    }

    public static class SshdThreadFactory
    extends AbstractLoggingBean
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public SshdThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            String effectiveName = name.replace(' ', '-');
            this.namePrefix = "sshd-" + effectiveName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t;
            try {
                t = System.getSecurityManager() != null ? AccessController.doPrivileged(() -> new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L)) : new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            }
            catch (PrivilegedActionException e) {
                Exception err = e.getException();
                if (err instanceof RuntimeException) {
                    throw (RuntimeException)err;
                }
                throw new RuntimeException(err);
            }
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("newThread({})[{}] runnable={}", this.group, t.getName(), r);
            }
            return t;
        }
    }
}

