/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.config;

import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolverUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.SshConfigFileReader;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.server.ServerBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.server.SshServer;
import io.jenkins.cli.shaded.org.apache.sshd.server.config.AllowTcpForwardingValue;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.AgentForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.ForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.TcpForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.X11ForwardingFilter;
import java.nio.file.Paths;

public final class SshServerConfigFileReader {
    public static final String ALLOW_TCP_FORWARDING_CONFIG_PROP = "AllowTcpForwarding";
    public static final String DEFAULT_TCP_FORWARDING = "yes";
    public static final String ALLOW_AGENT_FORWARDING_CONFIG_PROP = "AllowAgentForwarding";
    public static final String DEFAULT_AGENT_FORWARDING = "yes";
    public static final String ALLOW_X11_FORWARDING_CONFIG_PROP = "X11Forwarding";
    public static final String DEFAULT_X11_FORWARDING = "no";
    public static final String BANNER_CONFIG_PROP = "Banner";
    public static final String VISUAL_HOST_KEY = "VisualHostKey";
    public static final String DEFAULT_VISUAL_HOST_KEY = "no";

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <S extends SshServer> S configure(S server, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(server, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(server, props, lenient, ServerBuilder.DH2KEX, ignoreUnsupported);
        return server;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver options) {
        if (GenericUtils.isEmpty(options)) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(options);
        TcpForwardingFilter tcpFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(options);
        X11ForwardingFilter x11Filter = SshServerConfigFileReader.resolveX11ForwardingFilter(options);
        return ForwardingFilter.asForwardingFilter(agentFilter, x11Filter, tcpFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty(options, ALLOW_AGENT_FORWARDING_CONFIG_PROP, "yes");
        return AgentForwardingFilter.of(SshConfigFileReader.parseBooleanValue(value));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty(options, ALLOW_TCP_FORWARDING_CONFIG_PROP, "yes");
        AllowTcpForwardingValue filter = AllowTcpForwardingValue.fromString(value);
        ValidateUtils.checkNotNull(filter, "Unknown %s value: %s", ALLOW_TCP_FORWARDING_CONFIG_PROP, value);
        return filter;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver options) {
        String value = PropertyResolverUtils.getStringProperty(options, ALLOW_X11_FORWARDING_CONFIG_PROP, "no");
        return X11ForwardingFilter.of(SshConfigFileReader.parseBooleanValue(value));
    }

    public static Object resolveBanner(PropertyResolver options) {
        String bannerOption = PropertyResolverUtils.getString(options, BANNER_CONFIG_PROP);
        if (GenericUtils.isEmpty(bannerOption)) {
            bannerOption = PropertyResolverUtils.getStringProperty(options, VISUAL_HOST_KEY, "no");
            bannerOption = SshConfigFileReader.parseBooleanValue(bannerOption) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty(bannerOption)) {
            return "Welcome to SSHD\n";
        }
        if ("none".equals(bannerOption)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(bannerOption)) {
            return bannerOption;
        }
        return Paths.get(bannerOption, new String[0]);
    }
}

