/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.scp;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ScpTimestamp {
    private final long lastModifiedTime;
    private final long lastAccessTime;

    public ScpTimestamp(long modTime, long accTime) {
        this.lastModifiedTime = modTime;
        this.lastAccessTime = accTime;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String toString() {
        return "modified=" + new Date(this.lastModifiedTime) + ";accessed=" + new Date(this.lastAccessTime);
    }

    public static ScpTimestamp parseTime(String line) throws NumberFormatException {
        String[] numbers = GenericUtils.split(line.substring(1), ' ');
        return new ScpTimestamp(TimeUnit.SECONDS.toMillis(Long.parseLong(numbers[0])), TimeUnit.SECONDS.toMillis(Long.parseLong(numbers[2])));
    }
}

