/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io.mina;

import io.jenkins.cli.shaded.org.apache.mina.core.service.IoProcessor;
import io.jenkins.cli.shaded.org.apache.mina.core.service.SimpleIoProcessorPool;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.nio.NioProcessor;
import io.jenkins.cli.shaded.org.apache.mina.transport.socket.nio.NioSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.AbstractIoServiceFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoConnector;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaAcceptor;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.mina.MinaConnector;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ThreadUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class MinaServiceFactory
extends AbstractIoServiceFactory {
    private final IoProcessor<NioSession> ioProcessor;

    public MinaServiceFactory(FactoryManager factoryManager, ExecutorService service, boolean shutdownOnExit) {
        super(factoryManager, service == null ? ThreadUtils.newCachedThreadPool(factoryManager.toString() + "-mina") : service, service == null || shutdownOnExit);
        this.ioProcessor = new SimpleIoProcessorPool(NioProcessor.class, (Executor)this.getExecutorService(), MinaServiceFactory.getNioWorkers(factoryManager), null);
    }

    @Override
    public IoConnector createConnector(IoHandler handler) {
        return new MinaConnector(this.getFactoryManager(), handler, this.ioProcessor);
    }

    @Override
    public IoAcceptor createAcceptor(IoHandler handler) {
        return new MinaAcceptor(this.getFactoryManager(), handler, this.ioProcessor);
    }
}

