/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.impl;

import io.jenkins.cli.shaded.org.apache.sshd.client.ClientFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.client.SshClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpFileSystem;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpVersionSelector;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.impl.DefaultSftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.io.IOException;

public class DefaultSftpClientFactory
extends AbstractLoggingBean
implements SftpClientFactory {
    public static final DefaultSftpClientFactory INSTANCE = new DefaultSftpClientFactory();

    @Override
    public SftpClient createSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        DefaultSftpClient client = this.createDefaultSftpClient(session, selector);
        try {
            client.negotiateVersion(selector);
        }
        catch (IOException | RuntimeException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("createSftpClient({}) failed ({}) to negotiate version: {}", session, e.getClass().getSimpleName(), e.getMessage());
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("createSftpClient(" + session + ") version negotiation failure details", e);
            }
            client.close();
            throw e;
        }
        return client;
    }

    protected DefaultSftpClient createDefaultSftpClient(ClientSession session, SftpVersionSelector selector) throws IOException {
        return new DefaultSftpClient(session);
    }

    @Override
    public SftpFileSystem createSftpFileSystem(ClientSession session, SftpVersionSelector selector, int readBufferSize, int writeBufferSize) throws IOException {
        ClientFactoryManager manager = session.getFactoryManager();
        SftpFileSystemProvider provider = new SftpFileSystemProvider((SshClient)manager, selector);
        SftpFileSystem fs = provider.newFileSystem(session);
        fs.setReadBufferSize(readBufferSize);
        fs.setWriteBufferSize(writeBufferSize);
        return fs;
    }
}

