/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp;

import io.jenkins.cli.shaded.org.apache.sshd.client.SshClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpClient;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.SftpFileSystemProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.extensions.openssh.OpenSSHStatExtensionInfo;
import io.jenkins.cli.shaded.org.apache.sshd.client.subsystem.sftp.extensions.openssh.OpenSSHStatPathExtension;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KexProposalOption;
import io.jenkins.cli.shaded.org.apache.sshd.common.subsystem.sftp.SftpException;
import io.jenkins.cli.shaded.org.apache.sshd.common.subsystem.sftp.extensions.ParserUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.OsUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.NoCloseInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.channels.Channel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;

public class SftpCommand
implements Channel {
    public static final String SFTP_PORT_OPTION = "-P";
    private final SftpClient client;
    private final Map<String, CommandExecutor> commandsMap;
    private String cwdRemote;
    private String cwdLocal;

    public SftpCommand(SftpClient client) {
        this.client = Objects.requireNonNull(client, "No client");
        TreeMap<String, CommandExecutor> map = new TreeMap<String, CommandExecutor>(String.CASE_INSENSITIVE_ORDER);
        for (CommandExecutor e : Arrays.asList(new ExitCommandExecutor(), new PwdCommandExecutor(), new InfoCommandExecutor(), new SessionCommandExecutor(), new VersionCommandExecutor(), new CdCommandExecutor(), new LcdCommandExecutor(), new MkdirCommandExecutor(), new LsCommandExecutor(), new LStatCommandExecutor(), new ReadLinkCommandExecutor(), new RmCommandExecutor(), new RmdirCommandExecutor(), new RenameCommandExecutor(), new StatVfsCommandExecutor(), new GetCommandExecutor(), new PutCommandExecutor(), new HelpCommandExecutor())) {
            String name = e.getName();
            ValidateUtils.checkTrue(map.put(name, e) == null, "Multiple commands named '%s'", (Object)name);
        }
        this.commandsMap = Collections.unmodifiableMap(map);
        this.cwdLocal = System.getProperty("user.dir");
    }

    public final SftpClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInteractive(BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
        SftpClient sftp = this.getClient();
        this.setCurrentRemoteDirectory(sftp.canonicalPath("."));
        while (true) {
            String args;
            String cmd;
            stdout.append(this.getCurrentRemoteDirectory()).append(" > ").flush();
            String line = stdin.readLine();
            if (line == null) break;
            if (GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line))) continue;
            int pos = line.indexOf(32);
            if (pos > 0) {
                cmd = line.substring(0, pos);
                args = line.substring(pos + 1).trim();
            } else {
                cmd = line;
                args = "";
            }
            CommandExecutor exec = this.commandsMap.get(cmd);
            try {
                if (exec == null) {
                    stderr.append("Unknown command: ").println(line);
                    continue;
                }
                try {
                    if (!exec.executeCommand(args, stdin, stdout, stderr)) continue;
                }
                catch (Exception e) {
                    stderr.append(e.getClass().getSimpleName()).append(": ").println(e.getMessage());
                    continue;
                }
                finally {
                    stdout.flush();
                    continue;
                }
            }
            finally {
                stderr.flush();
                continue;
            }
            break;
        }
    }

    protected String resolveLocalPath(String pathArg) {
        String cwd = this.getCurrentLocalDirectory();
        if (GenericUtils.isEmpty(pathArg)) {
            return cwd;
        }
        if (OsUtils.isWin32() ? pathArg.length() >= 2 && pathArg.charAt(1) == ':' : pathArg.charAt(0) == '/') {
            return pathArg;
        }
        return cwd + File.separator + pathArg.replace('/', File.separatorChar);
    }

    protected String resolveRemotePath(String pathArg) {
        String cwd = this.getCurrentRemoteDirectory();
        if (GenericUtils.isEmpty(pathArg)) {
            return cwd;
        }
        if (pathArg.charAt(0) == '/') {
            return pathArg;
        }
        return cwd + "/" + pathArg;
    }

    protected <A extends Appendable> A appendFileAttributes(A stdout, SftpClient sftp, String path, SftpClient.Attributes attrs) throws IOException {
        stdout.append('\t').append(Long.toString(attrs.getSize())).append('\t').append(SftpFileSystemProvider.getRWXPermissions(attrs.getPermissions()));
        if (attrs.isSymbolicLink()) {
            String linkValue = sftp.readLink(path);
            stdout.append(" => ").append('(').append(attrs.isDirectory() ? "dir" : "file").append(')').append(' ').append(linkValue);
        }
        return stdout;
    }

    public String getCurrentRemoteDirectory() {
        return this.cwdRemote;
    }

    public void setCurrentRemoteDirectory(String path) {
        this.cwdRemote = path;
    }

    public String getCurrentLocalDirectory() {
        return this.cwdLocal;
    }

    public void setCurrentLocalDirectory(String path) {
        this.cwdLocal = path;
    }

    @Override
    public boolean isOpen() {
        return this.client.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen()) {
            this.client.close();
        }
    }

    public static <A extends Appendable> A appendInfoValue(A sb, CharSequence name, Object value) throws IOException {
        sb.append('\t').append(name).append(": ").append(Objects.toString(value));
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        OutputStream logStream = stderr;
        try (BufferedReader stdin = new BufferedReader(new InputStreamReader(new NoCloseInputStream(System.in)));){
            ClientSession session;
            Level level = SshClient.resolveLoggingVerbosity(args);
            logStream = SshClient.resolveLoggingTargetStream(stdout, stderr, args);
            if (logStream != null) {
                SshClient.setupLogging(level, stdout, stderr, logStream);
            }
            ClientSession clientSession = session = logStream == null ? null : SshClient.setupClientSession(SFTP_PORT_OPTION, stdin, stdout, stderr, args);
            if (session == null) {
                System.err.println("usage: sftp [-v[v][v]] [-E logoutput] [-i identity] [-l login] [-P port] [-o option=value] [-w password] [-c cipherlist]  [-m maclist] [-C] hostname/user@host");
                System.exit(-1);
                return;
            }
            try (SftpCommand sftp = new SftpCommand(session.createSftpClient());){
                sftp.doInteractive(stdin, stdout, stderr);
            }
            finally {
                session.close();
            }
        }
        finally {
            if (logStream != stdout && logStream != stderr) {
                logStream.close();
            }
        }
    }

    private class PutCommandExecutor
    extends TransferCommandExecutor {
        PutCommandExecutor() {
        }

        @Override
        public String getName() {
            return "put";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            this.executeCommand(args, true, stdout);
            return false;
        }
    }

    private class GetCommandExecutor
    extends TransferCommandExecutor {
        GetCommandExecutor() {
        }

        @Override
        public String getName() {
            return "get";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            this.executeCommand(args, false, stdout);
            return false;
        }
    }

    private abstract class TransferCommandExecutor
    implements CommandExecutor {
        protected TransferCommandExecutor() {
        }

        protected void createDirectories(SftpClient sftp, String remotePath) throws IOException {
            try {
                SftpClient.Attributes attrs = sftp.stat(remotePath);
                ValidateUtils.checkTrue(attrs.isDirectory(), "Remote path already exists but is not a directory: %s", (Object)remotePath);
                return;
            }
            catch (SftpException e) {
                int status = e.getStatus();
                ValidateUtils.checkTrue(status == 2, "Failed to get status of %s: %s", remotePath, e.getMessage());
                int pos = remotePath.lastIndexOf(47);
                ValidateUtils.checkTrue(pos > 0, "No more parents for %s", (Object)remotePath);
                this.createDirectories(sftp, remotePath.substring(0, pos));
                return;
            }
        }

        protected void transferFile(SftpClient sftp, Path localPath, String remotePath, boolean upload, PrintStream stdout, boolean verbose) throws IOException {
            if (upload) {
                int pos = remotePath.lastIndexOf(47);
                ValidateUtils.checkTrue(pos > 0, "Missing full remote file path: %s", (Object)remotePath);
                this.createDirectories(sftp, remotePath.substring(0, pos));
            } else {
                Files.createDirectories(localPath.getParent(), new FileAttribute[0]);
            }
            try (InputStream input = upload ? Files.newInputStream(localPath, new OpenOption[0]) : sftp.read(remotePath);
                 OutputStream output = upload ? sftp.write(remotePath) : Files.newOutputStream(localPath, new OpenOption[0]);){
                IoUtils.copy(input, output, 32768);
            }
            if (verbose) {
                stdout.append('\t').append("Copied ").append(upload ? localPath.toString() : remotePath).append(" to ").println(upload ? remotePath : localPath.toString());
            }
        }

        protected void transferRemoteDir(SftpClient sftp, Path localPath, String remotePath, SftpClient.Attributes attrs, PrintStream stdout, boolean verbose) throws IOException {
            if (attrs.isDirectory()) {
                for (SftpClient.DirEntry entry : sftp.readDir(remotePath)) {
                    String name = entry.getFilename();
                    if (".".equals(name) || "..".equals(name)) continue;
                    this.transferRemoteDir(sftp, localPath.resolve(name), remotePath + "/" + name, entry.getAttributes(), stdout, verbose);
                }
            } else if (attrs.isRegularFile()) {
                this.transferFile(sftp, localPath, remotePath, false, stdout, verbose);
            } else if (verbose) {
                stdout.append('\t').append("Skip remote special file ").println(remotePath);
            }
        }

        protected void transferLocalDir(SftpClient sftp, Path localPath, String remotePath, PrintStream stdout, boolean verbose) throws IOException {
            if (Files.isDirectory(localPath, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(localPath);){
                    for (Path entry : ds) {
                        String name = entry.getFileName().toString();
                        this.transferLocalDir(sftp, localPath.resolve(name), remotePath + "/" + name, stdout, verbose);
                    }
                }
            } else if (Files.isRegularFile(localPath, new LinkOption[0])) {
                this.transferFile(sftp, localPath, remotePath, true, stdout, verbose);
            } else if (verbose) {
                stdout.append('\t').append("Skip local special file ").println(localPath);
            }
        }

        protected void executeCommand(String args, boolean upload, PrintStream stdout) throws IOException {
            String remotePath;
            String localPath;
            String tgt;
            String[] comps = GenericUtils.split(args, ' ');
            int numArgs = GenericUtils.length(comps);
            ValidateUtils.checkTrue(numArgs >= 1 && numArgs <= 3, "Invalid number of arguments: %s", (Object)args);
            String src = comps[0];
            boolean recursive = false;
            boolean verbose = false;
            int tgtIndex = 1;
            if (src.charAt(0) == '-') {
                ValidateUtils.checkTrue(src.length() > 1, "Missing flags specification: %s", (Object)args);
                ValidateUtils.checkTrue(numArgs >= 2, "Missing source specification: %s", (Object)args);
                block4: for (int index = 1; index < src.length(); ++index) {
                    char ch = src.charAt(index);
                    switch (ch) {
                        case 'r': {
                            recursive = true;
                            continue block4;
                        }
                        case 'v': {
                            verbose = true;
                            continue block4;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown flag (" + String.valueOf(ch) + ")");
                        }
                    }
                }
                src = comps[1];
                ++tgtIndex;
            }
            String string = tgt = tgtIndex < numArgs ? comps[tgtIndex] : null;
            if (upload) {
                localPath = src;
                remotePath = ValidateUtils.checkNotNullAndNotEmpty(tgt, "No remote target specified: %s", (Object)args);
            } else {
                localPath = GenericUtils.isEmpty(tgt) ? SftpCommand.this.getCurrentLocalDirectory() : tgt;
                remotePath = src;
            }
            SftpClient sftp = SftpCommand.this.getClient();
            Path local = Paths.get(SftpCommand.this.resolveLocalPath(localPath), new String[0]).normalize().toAbsolutePath();
            String remote = SftpCommand.this.resolveRemotePath(remotePath);
            if (recursive) {
                if (upload) {
                    ValidateUtils.checkTrue(Files.isDirectory(local, new LinkOption[0]), "Local path not a directory or does not exist: %s", (Object)local);
                    this.transferLocalDir(sftp, local, remote, stdout, verbose);
                } else {
                    SftpClient.Attributes attrs = sftp.stat(remote);
                    ValidateUtils.checkTrue(attrs.isDirectory(), "Remote path not a directory: %s", (Object)remote);
                    this.transferRemoteDir(sftp, local, remote, attrs, stdout, verbose);
                }
            } else {
                if (Files.exists(local, new LinkOption[0]) && Files.isDirectory(local, new LinkOption[0])) {
                    int pos = remote.lastIndexOf(47);
                    String name = pos >= 0 ? remote.substring(pos + 1) : remote;
                    local = local.resolve(name);
                }
                this.transferFile(sftp, local, remote, upload, stdout, verbose);
            }
        }
    }

    private class HelpCommandExecutor
    implements CommandExecutor {
        HelpCommandExecutor() {
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            for (String cmd : SftpCommand.this.commandsMap.keySet()) {
                stdout.append('\t').println(cmd);
            }
            return false;
        }
    }

    private class ReadLinkCommandExecutor
    implements CommandExecutor {
        ReadLinkCommandExecutor() {
        }

        @Override
        public String getName() {
            return "readlink";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            ValidateUtils.checkTrue(GenericUtils.length(comps) <= 1, "Invalid number of arguments: %s", (Object)args);
            String path = GenericUtils.trimToEmpty(SftpCommand.this.resolveRemotePath(args));
            SftpClient client = SftpCommand.this.getClient();
            String linkData = client.readLink(path);
            stdout.append('\t').println(linkData);
            return false;
        }
    }

    private class LStatCommandExecutor
    implements CommandExecutor {
        LStatCommandExecutor() {
        }

        @Override
        public String getName() {
            return "lstat";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            ValidateUtils.checkTrue(GenericUtils.length(comps) <= 1, "Invalid number of arguments: %s", (Object)args);
            String path = GenericUtils.trimToEmpty(SftpCommand.this.resolveRemotePath(args));
            SftpClient client = SftpCommand.this.getClient();
            SftpClient.Attributes attrs = client.lstat(path);
            SftpCommand.this.appendFileAttributes(stdout, client, path, attrs).println();
            return false;
        }
    }

    private class StatVfsCommandExecutor
    implements CommandExecutor {
        StatVfsCommandExecutor() {
        }

        @Override
        public String getName() {
            return "statvfs@openssh.com";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            Field[] fields;
            String[] comps = GenericUtils.split(args, ' ');
            int numArgs = GenericUtils.length(comps);
            ValidateUtils.checkTrue(numArgs <= 1, "Invalid number of arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            OpenSSHStatPathExtension ext = sftp.getExtension(OpenSSHStatPathExtension.class);
            ValidateUtils.checkTrue(ext.isSupported(), "Extension not supported by server: %s", (Object)ext.getName());
            String remPath = SftpCommand.this.resolveRemotePath(numArgs >= 1 ? GenericUtils.trimToEmpty(comps[0]) : GenericUtils.trimToEmpty(args));
            OpenSSHStatExtensionInfo info = ext.stat(remPath);
            for (Field f : fields = info.getClass().getFields()) {
                String name = f.getName();
                int mod = f.getModifiers();
                if (Modifier.isStatic(mod)) continue;
                Object value = f.get(info);
                stdout.append('\t').append(name).append(": ").println(value);
            }
            return false;
        }
    }

    private class RenameCommandExecutor
    implements CommandExecutor {
        RenameCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rename";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            ValidateUtils.checkTrue(GenericUtils.length(comps) == 2, "Invalid number of arguments: %s", (Object)args);
            String oldPath = SftpCommand.this.resolveRemotePath(GenericUtils.trimToEmpty(comps[0]));
            String newPath = SftpCommand.this.resolveRemotePath(GenericUtils.trimToEmpty(comps[1]));
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.rename(oldPath, newPath);
            return false;
        }
    }

    private class RmdirCommandExecutor
    implements CommandExecutor {
        RmdirCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rmdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified");
            String path = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.rmdir(path);
            return false;
        }
    }

    private class RmCommandExecutor
    implements CommandExecutor {
        RmCommandExecutor() {
        }

        @Override
        public String getName() {
            return "rm";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String[] comps = GenericUtils.split(args, ' ');
            int numArgs = GenericUtils.length(comps);
            ValidateUtils.checkTrue(numArgs >= 1, "No arguments");
            ValidateUtils.checkTrue(numArgs <= 2, "Too many arguments: %s", (Object)args);
            String remotePath = comps[0];
            boolean recursive = false;
            boolean verbose = false;
            if (remotePath.charAt(0) == '-') {
                ValidateUtils.checkTrue(remotePath.length() > 1, "Missing flags specification: %s", (Object)args);
                ValidateUtils.checkTrue(numArgs == 2, "Missing remote directory: %s", (Object)args);
                block4: for (int index = 1; index < remotePath.length(); ++index) {
                    char ch = remotePath.charAt(index);
                    switch (ch) {
                        case 'r': {
                            recursive = true;
                            continue block4;
                        }
                        case 'v': {
                            verbose = true;
                            continue block4;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown flag (" + String.valueOf(ch) + ")");
                        }
                    }
                }
                remotePath = comps[1];
            }
            String path = SftpCommand.this.resolveRemotePath(remotePath);
            SftpClient sftp = SftpCommand.this.getClient();
            if (recursive) {
                SftpClient.Attributes attrs = sftp.stat(path);
                ValidateUtils.checkTrue(attrs.isDirectory(), "Remote path not a directory: %s", (Object)args);
                this.removeRecursive(sftp, path, attrs, stdout, verbose);
            } else {
                sftp.remove(path);
                if (verbose) {
                    stdout.append('\t').append("Removed ").println(path);
                }
            }
            return false;
        }

        private void removeRecursive(SftpClient sftp, String path, SftpClient.Attributes attrs, PrintStream stdout, boolean verbose) throws IOException {
            if (attrs.isDirectory()) {
                for (SftpClient.DirEntry entry : sftp.readDir(path)) {
                    String name = entry.getFilename();
                    if (".".equals(name) || "..".equals(name)) continue;
                    this.removeRecursive(sftp, path + "/" + name, entry.getAttributes(), stdout, verbose);
                }
                sftp.rmdir(path);
            } else if (attrs.isRegularFile()) {
                sftp.remove(path);
            } else if (verbose) {
                stdout.append('\t').append("Skip special file ").println(path);
                return;
            }
            if (verbose) {
                stdout.append('\t').append("Removed ").println(path);
            }
        }
    }

    private class LsCommandExecutor
    implements CommandExecutor {
        LsCommandExecutor() {
        }

        @Override
        public String getName() {
            return "ls";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            String flags;
            String[] comps = GenericUtils.split(args, ' ');
            int numComps = GenericUtils.length(comps);
            String pathArg = numComps <= 0 ? null : GenericUtils.trimToEmpty(comps[numComps - 1]);
            String string = flags = numComps >= 2 ? GenericUtils.trimToEmpty(comps[0]) : null;
            if (GenericUtils.length(pathArg) > 0 && pathArg.charAt(0) == '-') {
                flags = pathArg;
                pathArg = null;
            }
            String path = SftpCommand.this.resolveRemotePath(pathArg);
            SftpClient sftp = SftpCommand.this.getClient();
            int version = sftp.getVersion();
            boolean showLongName = version == 3 && GenericUtils.length(flags) > 1 && flags.indexOf(108) > 0;
            for (SftpClient.DirEntry entry : sftp.readDir(path)) {
                String fileName = entry.getFilename();
                SftpClient.Attributes attrs = entry.getAttributes();
                SftpCommand.this.appendFileAttributes(stdout.append('\t').append(fileName), sftp, path + "/" + fileName, attrs).println();
                if (!showLongName) continue;
                stdout.append("\t\tlong-name: ").println(entry.getLongFilename());
            }
            return false;
        }
    }

    private class MkdirCommandExecutor
    implements CommandExecutor {
        MkdirCommandExecutor() {
        }

        @Override
        public String getName() {
            return "mkdir";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified");
            String path = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            sftp.mkdir(path);
            return false;
        }
    }

    private class LcdCommandExecutor
    extends PwdCommandExecutor {
        LcdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "lcd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            if (GenericUtils.isEmpty(args)) {
                SftpCommand.this.setCurrentLocalDirectory(System.getProperty("user.home"));
            } else {
                Path path = Paths.get(SftpCommand.this.resolveLocalPath(args), new String[0]).normalize().toAbsolutePath();
                ValidateUtils.checkTrue(Files.exists(path, new LinkOption[0]), "No such local directory: %s", (Object)path);
                ValidateUtils.checkTrue(Files.isDirectory(path, new LinkOption[0]), "Path is not a directory: %s", (Object)path);
                SftpCommand.this.setCurrentLocalDirectory(path.toString());
            }
            return super.executeCommand("", stdin, stdout, stderr);
        }
    }

    private class CdCommandExecutor
    extends PwdCommandExecutor {
        CdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "cd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkNotNullAndNotEmpty(args, "No remote directory specified");
            String newPath = SftpCommand.this.resolveRemotePath(args);
            SftpClient sftp = SftpCommand.this.getClient();
            SftpCommand.this.setCurrentRemoteDirectory(sftp.canonicalPath(newPath));
            return super.executeCommand("", stdin, stdout, stderr);
        }
    }

    private class VersionCommandExecutor
    implements CommandExecutor {
        VersionCommandExecutor() {
        }

        @Override
        public String getName() {
            return "version";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            stdout.append('\t').println(sftp.getVersion());
            return false;
        }
    }

    private class InfoCommandExecutor
    implements CommandExecutor {
        InfoCommandExecutor() {
        }

        @Override
        public String getName() {
            return "info";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            Object session = sftp.getSession();
            stdout.append('\t').println(session.getServerVersion());
            NavigableMap<String, byte[]> extensions = sftp.getServerExtensions();
            Map<String, Object> parsed = ParserUtils.parse(extensions);
            if (GenericUtils.size(extensions) > 0) {
                stdout.println();
            }
            extensions.forEach((name, value) -> {
                Object info = parsed.get(name);
                stdout.append('\t').append((CharSequence)name).append(": ");
                if (info == null) {
                    stdout.println(BufferUtils.toHex(value));
                } else {
                    stdout.println(info);
                }
            });
            return false;
        }
    }

    private class SessionCommandExecutor
    implements CommandExecutor {
        SessionCommandExecutor() {
        }

        @Override
        public String getName() {
            return "session";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            SftpClient sftp = SftpCommand.this.getClient();
            ClientSession session = (ClientSession)sftp.getSession();
            SftpCommand.appendInfoValue(stdout, "Session ID", BufferUtils.toHex(session.getSessionId())).println();
            SftpCommand.appendInfoValue(stdout, "Connect address", session.getConnectAddress()).println();
            IoSession ioSession = session.getIoSession();
            SftpCommand.appendInfoValue(stdout, "Local address", ioSession.getLocalAddress()).println();
            SftpCommand.appendInfoValue(stdout, "Remote address", ioSession.getRemoteAddress()).println();
            for (KexProposalOption option : KexProposalOption.VALUES) {
                SftpCommand.appendInfoValue(stdout, option.getDescription(), session.getNegotiatedKexParameter(option)).println();
            }
            return false;
        }
    }

    private class PwdCommandExecutor
    implements CommandExecutor {
        protected PwdCommandExecutor() {
        }

        @Override
        public String getName() {
            return "pwd";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            stdout.append('\t').append("Remote: ").println(SftpCommand.this.getCurrentRemoteDirectory());
            stdout.append('\t').append("Local: ").println(SftpCommand.this.getCurrentLocalDirectory());
            return false;
        }
    }

    private static class ExitCommandExecutor
    implements CommandExecutor {
        ExitCommandExecutor() {
        }

        @Override
        public String getName() {
            return "exit";
        }

        @Override
        public boolean executeCommand(String args, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
            ValidateUtils.checkTrue(GenericUtils.isEmpty(args), "Unexpected arguments: %s", (Object)args);
            stdout.println("Exiting");
            return true;
        }
    }

    public static interface CommandExecutor
    extends NamedResource {
        public boolean executeCommand(String var1, BufferedReader var2, PrintStream var3, PrintStream var4) throws Exception;
    }
}

