/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CLI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FullDuplexHttpStream {
    private final URL base;
    private final OutputStream output;
    private final InputStream input;
    static final int BLOCK_SIZE = 1024;
    static final Logger LOGGER = Logger.getLogger(FullDuplexHttpStream.class.getName());

    public InputStream getInputStream() {
        return this.input;
    }

    public OutputStream getOutputStream() {
        return this.output;
    }

    public FullDuplexHttpStream(URL base, String relativeTarget, String authorization) throws IOException {
        if (!base.toString().endsWith("/")) {
            throw new IllegalArgumentException(base.toString());
        }
        if (relativeTarget.startsWith("/")) {
            throw new IllegalArgumentException(relativeTarget);
        }
        this.base = this.tryToResolveRedirects(base, authorization);
        URL target = new URL(this.base, relativeTarget);
        UUID uuid = UUID.randomUUID();
        LOGGER.fine("establishing download side");
        HttpURLConnection con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.addRequestProperty("Session", uuid.toString());
        con.addRequestProperty("Side", "download");
        if (authorization != null) {
            con.addRequestProperty("Authorization", authorization);
        }
        con.getOutputStream().close();
        this.input = con.getInputStream();
        if (con.getHeaderField("Hudson-Duplex") == null) {
            throw new CLI.NotTalkingToJenkinsException("There's no Jenkins running at " + target + ", or is not serving the HTTP Duplex transport");
        }
        LOGGER.fine("established download side");
        LOGGER.fine("establishing upload side");
        con = (HttpURLConnection)target.openConnection();
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setChunkedStreamingMode(0);
        con.setRequestProperty("Content-type", "application/octet-stream");
        con.addRequestProperty("Session", uuid.toString());
        con.addRequestProperty("Side", "upload");
        if (authorization != null) {
            con.addRequestProperty("Authorization", authorization);
        }
        this.output = con.getOutputStream();
        LOGGER.fine("established upload side");
    }

    private URL tryToResolveRedirects(URL base, String authorization) {
        try {
            HttpURLConnection con = (HttpURLConnection)base.openConnection();
            if (authorization != null) {
                con.addRequestProperty("Authorization", authorization);
            }
            con.getInputStream().close();
            base = con.getURL();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to resolve potential redirects", ex);
        }
        return base;
    }
}

