/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.cli.CLIConnectionFactory;
import hudson.cli.FullDuplexHttpStream;
import hudson.cli.NoCheckTrustManager;
import hudson.cli.PlainCLIProtocol;
import hudson.cli.PrivateKeyProvider;
import hudson.cli.SSHCLI;
import hudson.cli.client.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class CLI {
    static final Logger LOGGER = Logger.getLogger(CLI.class.getName());

    private CLI() {
    }

    static void verifyJenkinsConnection(URLConnection c) throws IOException {
        if (c.getHeaderField("X-Hudson") == null && c.getHeaderField("X-Jenkins") == null) {
            throw new NotTalkingToJenkinsException(c);
        }
    }

    public static void main(String[] _args) throws Exception {
        try {
            System.exit(CLI._main(_args));
        }
        catch (NotTalkingToJenkinsException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }

    public static int _main(String[] _args) throws Exception {
        List<String> args = Arrays.asList(_args);
        PrivateKeyProvider provider = new PrivateKeyProvider();
        String url = System.getenv("JENKINS_URL");
        if (url == null) {
            url = System.getenv("HUDSON_URL");
        }
        boolean tryLoadPKey = true;
        Mode mode = null;
        String user = null;
        String auth = null;
        String userIdEnv = System.getenv("JENKINS_USER_ID");
        String tokenEnv = System.getenv("JENKINS_API_TOKEN");
        boolean strictHostKey = false;
        while (!args.isEmpty()) {
            String head = args.get(0);
            if (head.equals("-version")) {
                System.out.println("Version: " + CLI.computeVersion());
                return 0;
            }
            if (head.equals("-http")) {
                if (mode != null) {
                    CLI.printUsage("-http clashes with previously defined mode " + (Object)((Object)mode));
                    return -1;
                }
                mode = Mode.HTTP;
                args = args.subList(1, args.size());
                continue;
            }
            if (head.equals("-ssh")) {
                if (mode != null) {
                    CLI.printUsage("-ssh clashes with previously defined mode " + (Object)((Object)mode));
                    return -1;
                }
                mode = Mode.SSH;
                args = args.subList(1, args.size());
                continue;
            }
            if (head.equals("-remoting")) {
                CLI.printUsage("-remoting mode is no longer supported");
                return -1;
            }
            if (head.equals("-s") && args.size() >= 2) {
                url = args.get(1);
                args = args.subList(2, args.size());
                continue;
            }
            if (head.equals("-noCertificateCheck")) {
                LOGGER.info("Skipping HTTPS certificate checks altogether. Note that this is not secure at all.");
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new NoCheckTrustManager()}, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
                args = args.subList(1, args.size());
                continue;
            }
            if (head.equals("-noKeyAuth")) {
                tryLoadPKey = false;
                args = args.subList(1, args.size());
                continue;
            }
            if (head.equals("-i") && args.size() >= 2) {
                File f = new File(args.get(1));
                if (!f.exists()) {
                    CLI.printUsage(Messages.CLI_NoSuchFileExists(f));
                    return -1;
                }
                provider.readFrom(f);
                args = args.subList(2, args.size());
                continue;
            }
            if (head.equals("-strictHostKey")) {
                strictHostKey = true;
                args = args.subList(1, args.size());
                continue;
            }
            if (head.equals("-user") && args.size() >= 2) {
                user = args.get(1);
                args = args.subList(2, args.size());
                continue;
            }
            if (head.equals("-auth") && args.size() >= 2) {
                auth = args.get(1);
                args = args.subList(2, args.size());
                continue;
            }
            if (!head.equals("-logger") || args.size() < 2) break;
            Level level = Level.parse(args.get(1));
            for (Handler h : Logger.getLogger("").getHandlers()) {
                h.setLevel(level);
            }
            for (Logger logger : new Logger[]{LOGGER, FullDuplexHttpStream.LOGGER, PlainCLIProtocol.LOGGER, Logger.getLogger("org.apache.sshd")}) {
                logger.setLevel(level);
            }
            args = args.subList(2, args.size());
        }
        if (url == null) {
            CLI.printUsage(Messages.CLI_NoURL());
            return -1;
        }
        if (auth == null) {
            if (StringUtils.isNotBlank((String)userIdEnv) && StringUtils.isNotBlank((String)tokenEnv)) {
                auth = StringUtils.defaultString((String)userIdEnv).concat(":").concat(StringUtils.defaultString((String)tokenEnv));
            } else if (StringUtils.isNotBlank((String)userIdEnv) || StringUtils.isNotBlank((String)tokenEnv)) {
                CLI.printUsage(Messages.CLI_BadAuth());
                return -1;
            }
        }
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        if (args.isEmpty()) {
            args = Arrays.asList("help");
        }
        if (tryLoadPKey && !provider.hasKeys()) {
            provider.readFromDefaultLocations();
        }
        if (mode == null) {
            mode = Mode.HTTP;
        }
        LOGGER.log(Level.FINE, "using connection mode {0}", (Object)mode);
        if (user != null && auth != null) {
            LOGGER.warning("-user and -auth are mutually exclusive");
        }
        if (mode == Mode.SSH) {
            if (user == null) {
                LOGGER.warning("-user required when using -ssh");
                return -1;
            }
            return SSHCLI.sshConnection(url, user, args, provider, strictHostKey);
        }
        if (strictHostKey) {
            LOGGER.warning("-strictHostKey meaningful only with -ssh");
        }
        if (user != null) {
            LOGGER.warning("Warning: -user ignored unless using -ssh");
        }
        CLIConnectionFactory factory = new CLIConnectionFactory();
        String userInfo = new URL(url).getUserInfo();
        if (userInfo != null) {
            factory = factory.basicAuth(userInfo);
        } else if (auth != null) {
            factory = factory.basicAuth(auth.startsWith("@") ? FileUtils.readFileToString((File)new File(auth.substring(1))).trim() : auth);
        }
        if (mode == Mode.HTTP) {
            return CLI.plainHttpConnection(url, args, factory);
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int plainHttpConnection(String url, List<String> args, CLIConnectionFactory factory) throws IOException, InterruptedException {
        LOGGER.log(Level.FINE, "Trying to connect to {0} via plain protocol over HTTP", url);
        FullDuplexHttpStream streams = new FullDuplexHttpStream(new URL(url), "cli?remoting=false", factory.authorization);
        class ClientSideImpl
        extends PlainCLIProtocol.ClientSide {
            boolean complete;
            int exit = -1;

            ClientSideImpl(InputStream is, OutputStream os) throws IOException {
                super(is, os);
                if (is.read() != 0) {
                    throw new IOException("expected to see initial zero byte; perhaps you are connecting to an old server which does not support -http?");
                }
            }

            @Override
            protected void onExit(int code) {
                this.exit = code;
                this.finished();
            }

            @Override
            protected void onStdout(byte[] chunk) throws IOException {
                System.out.write(chunk);
            }

            @Override
            protected void onStderr(byte[] chunk) throws IOException {
                System.err.write(chunk);
            }

            @Override
            protected void handleClose() {
                this.finished();
            }

            private synchronized void finished() {
                this.complete = true;
                this.notifyAll();
            }
        }
        try (final ClientSideImpl connection = new ClientSideImpl(streams.getInputStream(), streams.getOutputStream());){
            for (String arg : args) {
                connection.sendArg(arg);
            }
            connection.sendEncoding(Charset.defaultCharset().name());
            connection.sendLocale(Locale.getDefault().toString());
            connection.sendStart();
            connection.begin();
            new Thread("input reader"){
                {
                    super(x0);
                }

                @Override
                public void run() {
                    try {
                        int c;
                        OutputStream stdin = connection.streamStdin();
                        while (!connection.complete && (c = System.in.read()) != -1) {
                            stdin.write(c);
                        }
                        connection.sendEndStdin();
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }.start();
            new Thread("ping"){
                {
                    super(x0);
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                        while (!connection.complete) {
                            LOGGER.fine("sending ping");
                            connection.sendEncoding(Charset.defaultCharset().name());
                            Thread.sleep(10000L);
                        }
                    }
                    catch (IOException | InterruptedException x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }.start();
            ClientSideImpl clientSideImpl = connection;
            synchronized (clientSideImpl) {
                while (!connection.complete) {
                    connection.wait();
                }
            }
            int n = connection.exit;
            return n;
        }
    }

    private static String computeVersion() {
        Properties props;
        block5: {
            props = new Properties();
            try {
                InputStream is = CLI.class.getResourceAsStream("/jenkins/cli/jenkins-cli-version.properties");
                if (is == null) break block5;
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props.getProperty("version", "?");
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(f, passwd);
    }

    public static KeyPair loadKey(File f) throws IOException, GeneralSecurityException {
        return CLI.loadKey(f, null);
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(pemString, passwd);
    }

    public static KeyPair loadKey(String pemString) throws IOException, GeneralSecurityException {
        return CLI.loadKey(pemString, null);
    }

    static String usage() {
        return Messages.CLI_Usage();
    }

    private static void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.err.println(CLI.usage());
    }

    private static enum Mode {
        HTTP,
        SSH;

    }

    static final class NotTalkingToJenkinsException
    extends IOException {
        public NotTalkingToJenkinsException(String s) {
            super(s);
        }

        public NotTalkingToJenkinsException(URLConnection c) {
            super("There's no Jenkins running at " + c.getURL().toString());
        }
    }
}

