/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.walk;

import java.util.ArrayList;
import java.util.Collections;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.SchemaVersion;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ExceptionProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.SchemaWalkingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.TokenResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.syntax.DraftV3SyntaxCheckerDictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.syntax.DraftV4SyntaxCheckerDictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.SchemaLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SchemaWalkerMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessorChain;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.ref.RefResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.SchemaTreeEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.walk.SchemaListener;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.walk.SchemaWalker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.walk.collectors.PointerCollector;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;

public final class ResolvingSchemaWalker
extends SchemaWalker {
    private static final ProcessingMessage MESSAGE = new ProcessingMessage().message(SyntaxMessages.INVALID_SCHEMA).setExceptionProvider(new ExceptionProvider(){

        @Override
        public ProcessingException doException(ProcessingMessage message) {
            return new InvalidSchemaException(message);
        }
    });
    private static final Equivalence<SchemaTree> EQUIVALENCE = SchemaTreeEquivalence.getInstance();
    private final Processor<SchemaHolder, SchemaHolder> processor;

    public ResolvingSchemaWalker(SchemaTree tree, SchemaVersion version, LoadingConfiguration cfg) {
        super(tree, version);
        Dictionary<SyntaxChecker> checkers = version == SchemaVersion.DRAFTV4 ? DraftV4SyntaxCheckerDictionary.get() : DraftV3SyntaxCheckerDictionary.get();
        RefResolver refResolver = new RefResolver(new SchemaLoader(cfg));
        this.processor = ProcessorChain.startWith(refResolver).chainWith(new SyntaxProcessor(checkers)).failOnError(MESSAGE).getProcessor();
    }

    public ResolvingSchemaWalker(SchemaTree tree, SchemaVersion version) {
        this(tree, version, LoadingConfiguration.byDefault());
    }

    public ResolvingSchemaWalker(SchemaTree tree, Dictionary<PointerCollector> collectors, Dictionary<SyntaxChecker> checkers, LoadingConfiguration cfg) {
        super(tree, collectors);
        RefResolver refResolver = new RefResolver(new SchemaLoader(cfg));
        this.processor = ProcessorChain.startWith(refResolver).chainWith(new SyntaxProcessor(checkers)).failOnError(MESSAGE).getProcessor();
    }

    @Override
    public <T> void resolveTree(SchemaListener<T> listener, ProcessingReport report) throws ProcessingException {
        SchemaTree newTree = (SchemaTree)this.processor.process(report, new SchemaHolder(this.tree)).getValue();
        if (EQUIVALENCE.equivalent(this.tree, newTree)) {
            return;
        }
        ResolvingSchemaWalker.checkTrees(this.tree, newTree);
        listener.onNewTree(this.tree, newTree);
        this.tree = newTree;
    }

    @Override
    public String toString() {
        return "recursive tree walker ($ref resolution)";
    }

    private static void checkTrees(SchemaTree tree, SchemaTree newTree) throws ProcessingException {
        if (!tree.getLoadingRef().equals(newTree.getLoadingRef())) {
            return;
        }
        JsonPointer sourcePointer = tree.getPointer();
        JsonPointer targetPointer = newTree.getPointer();
        ArrayList<TokenResolver<JsonNode>> sourceTokens = Lists.newArrayList(sourcePointer);
        ArrayList<TokenResolver<JsonNode>> targetTokens = Lists.newArrayList(targetPointer);
        ProcessingMessage message = new ProcessingMessage().message("").put("schemaURI", tree.getLoadingRef()).put("source", sourcePointer.toString()).put("target", targetPointer.toString());
        if (Collections.indexOfSubList(sourceTokens, targetTokens) == 0) {
            throw new SchemaWalkingException(message.message(SchemaWalkerMessages.PARENT_EXPAND));
        }
        if (Collections.indexOfSubList(targetTokens, sourceTokens) == 0) {
            throw new SchemaWalkingException(message.message(SchemaWalkerMessages.SUBTREE_EXPAND));
        }
    }
}

