/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ObjectReader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.io.Closeables;

public final class JacksonUtils {
    private static final JsonNodeFactory FACTORY = JsonNodeFactory.withExactBigDecimals(false);
    private static final ObjectReader READER;
    private static final ObjectWriter WRITER;

    private JacksonUtils() {
    }

    public static ObjectReader getReader() {
        return READER;
    }

    public static JsonNodeFactory nodeFactory() {
        return FACTORY;
    }

    public static Map<String, JsonNode> asMap(JsonNode node) {
        if (!node.isObject()) {
            return Collections.emptyMap();
        }
        Iterator<Map.Entry<String, JsonNode>> iterator = node.fields();
        HashMap<String, JsonNode> ret = Maps.newHashMap();
        while (iterator.hasNext()) {
            Map.Entry<String, JsonNode> entry = iterator.next();
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prettyPrint(JsonNode node) {
        StringWriter writer = new StringWriter();
        try {
            WRITER.writeValue(writer, (Object)node);
            writer.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            Closeables.closeQuietly(writer);
        }
        return writer.toString();
    }

    static {
        ObjectMapper mapper = new ObjectMapper().setNodeFactory(FACTORY).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        READER = mapper.reader();
        WRITER = mapper.writerWithDefaultPrettyPrinter();
    }
}

