/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree;

import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.BaseSchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.ImmutableMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

public final class InlineSchemaTree
extends BaseSchemaTree {
    private final Map<JsonRef, JsonPointer> absRefs;
    private final Map<JsonRef, JsonPointer> otherRefs;

    public InlineSchemaTree(JsonNode baseNode) {
        this(JsonRef.emptyRef(), baseNode);
    }

    public InlineSchemaTree(JsonRef loadingRef, JsonNode baseNode) {
        super(loadingRef, baseNode, JsonPointer.empty());
        HashMap<JsonRef, JsonPointer> abs = Maps.newHashMap();
        HashMap<JsonRef, JsonPointer> other = Maps.newHashMap();
        InlineSchemaTree.walk(loadingRef, baseNode, JsonPointer.empty(), abs, other);
        this.absRefs = ImmutableMap.copyOf(abs);
        this.otherRefs = ImmutableMap.copyOf(other);
    }

    private InlineSchemaTree(InlineSchemaTree other, JsonPointer newPointer) {
        super(other, newPointer);
        this.absRefs = other.absRefs;
        this.otherRefs = other.otherRefs;
    }

    @Override
    public SchemaTree append(JsonPointer pointer) {
        JsonPointer newPointer = this.pointer.append(pointer);
        return new InlineSchemaTree(this, newPointer);
    }

    @Override
    public SchemaTree setPointer(JsonPointer pointer) {
        return new InlineSchemaTree(this, pointer);
    }

    @Override
    public boolean containsRef(JsonRef ref) {
        return this.getMatchingPointer(ref) != null;
    }

    @Override
    public JsonPointer matchingPointer(JsonRef ref) {
        JsonPointer ret = this.getMatchingPointer(ref);
        if (ret == null) {
            return null;
        }
        return ret.path(this.baseNode).isMissingNode() ? null : ret;
    }

    private JsonPointer getMatchingPointer(JsonRef ref) {
        if (this.otherRefs.containsKey(ref)) {
            return this.otherRefs.get(ref);
        }
        if (!ref.isLegal()) {
            return null;
        }
        return this.refMatchingPointer(ref);
    }

    private JsonPointer refMatchingPointer(JsonRef ref) {
        JsonPointer refPtr = ref.getPointer();
        for (Map.Entry<JsonRef, JsonPointer> entry : this.absRefs.entrySet()) {
            if (!entry.getKey().contains(ref)) continue;
            return entry.getValue().append(refPtr);
        }
        return this.loadingRef.contains(ref) ? refPtr : null;
    }

    private static void walk(JsonRef baseRef, JsonNode node, JsonPointer ptr, Map<JsonRef, JsonPointer> absMap, Map<JsonRef, JsonPointer> otherMap) {
        if (!node.isObject()) {
            return;
        }
        JsonRef ref = InlineSchemaTree.idFromNode(node);
        JsonRef nextRef = baseRef;
        if (ref != null) {
            nextRef = baseRef.resolve(ref);
            Map<JsonRef, JsonPointer> targetMap = nextRef.isAbsolute() ? absMap : otherMap;
            targetMap.put(nextRef, ptr);
        }
        Map<String, JsonNode> tmp = JacksonUtils.asMap(node);
        for (Map.Entry<String, JsonNode> entry : tmp.entrySet()) {
            InlineSchemaTree.walk(nextRef, entry.getValue(), ptr.append(entry.getKey()), absMap, otherMap);
        }
    }
}

