/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report;

import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ExceptionProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ProcessingErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.SimpleExceptionProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.AsJson;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.JacksonUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Preconditions;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

@NotThreadSafe
public final class ProcessingMessage
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final Map<String, JsonNode> map = Maps.newLinkedHashMap();
    private ExceptionProvider exceptionProvider = SimpleExceptionProvider.getInstance();
    private LogLevel level;

    public ProcessingMessage() {
        this.setLogLevel(LogLevel.INFO);
    }

    public ProcessingMessage setExceptionProvider(ExceptionProvider exceptionProvider) {
        if (exceptionProvider == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_EXCEPTION_PROVIDER));
        }
        this.exceptionProvider = exceptionProvider;
        return this;
    }

    public ProcessingMessage setLogLevel(LogLevel level) {
        if (level == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_LEVEL));
        }
        this.level = Preconditions.checkNotNull(level, "log level cannot be null");
        return this.put("level", level);
    }

    public ProcessingMessage message(String message) {
        return this.put("message", message);
    }

    public <T> ProcessingMessage message(T value) {
        return this.put("message", value);
    }

    public String getMessage() {
        return this.map.containsKey("message") ? this.map.get("message").asText() : "(no message)";
    }

    public ProcessingMessage put(String key, JsonNode value) {
        if (key == null) {
            return this;
        }
        if (value == null) {
            return this.putNull(key);
        }
        this.map.put(key, (JsonNode)value.deepCopy());
        return this;
    }

    public ProcessingMessage put(String key, AsJson asJson) {
        return this.put(key, asJson.asJson());
    }

    public ProcessingMessage put(String key, String value) {
        return value == null ? this.putNull(key) : this.put(key, FACTORY.textNode(value));
    }

    public ProcessingMessage put(String key, int value) {
        return this.put(key, FACTORY.numberNode(value));
    }

    public <T> ProcessingMessage put(String key, T value) {
        return value == null ? this.putNull(key) : this.put(key, FACTORY.textNode(value.toString()));
    }

    public <T> ProcessingMessage put(String key, Iterable<T> values) {
        if (values == null) {
            return this.putNull(key);
        }
        ArrayNode node = FACTORY.arrayNode();
        for (T value : values) {
            node.add(value == null ? FACTORY.nullNode() : FACTORY.textNode(value.toString()));
        }
        return this.put(key, node);
    }

    public LogLevel getLogLevel() {
        return this.level;
    }

    private ProcessingMessage putNull(String key) {
        if (key == null) {
            return this;
        }
        this.map.put(key, FACTORY.nullNode());
        return this;
    }

    @Override
    public JsonNode asJson() {
        ObjectNode ret = FACTORY.objectNode();
        ret.putAll(this.map);
        return ret;
    }

    public ProcessingException asException() {
        return this.exceptionProvider.doException(this);
    }

    public String toString() {
        return this.map.toString();
    }
}

