/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report;

import java.util.Iterator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Objects;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Iterators;

public abstract class AbstractProcessingReport
implements ProcessingReport {
    private LogLevel currentLevel = LogLevel.DEBUG;
    private final LogLevel logLevel;
    private final LogLevel exceptionThreshold;

    protected AbstractProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        this.logLevel = logLevel;
        this.exceptionThreshold = exceptionThreshold;
    }

    protected AbstractProcessingReport(LogLevel logLevel) {
        this(logLevel, LogLevel.FATAL);
    }

    protected AbstractProcessingReport() {
        this(LogLevel.INFO, LogLevel.FATAL);
    }

    @Override
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public final LogLevel getExceptionThreshold() {
        return this.exceptionThreshold;
    }

    @Override
    public final void debug(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.DEBUG));
    }

    @Override
    public final void info(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.INFO));
    }

    @Override
    public final void warn(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.WARNING));
    }

    @Override
    public final void error(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.ERROR));
    }

    @Override
    public final void fatal(ProcessingMessage message) throws ProcessingException {
        this.dispatch(message.setLogLevel(LogLevel.FATAL));
    }

    @Override
    public final boolean isSuccess() {
        return this.currentLevel.compareTo(LogLevel.ERROR) < 0;
    }

    public abstract void log(LogLevel var1, ProcessingMessage var2);

    protected final void dispatch(ProcessingMessage message) throws ProcessingException {
        LogLevel level = message.getLogLevel();
        if (level.compareTo(this.exceptionThreshold) >= 0) {
            throw message.asException();
        }
        if (level.compareTo(this.currentLevel) > 0) {
            this.currentLevel = level;
        }
        if (level.compareTo(this.logLevel) >= 0) {
            this.log(level, message);
        }
    }

    @Override
    public Iterator<ProcessingMessage> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public final void mergeWith(ProcessingReport other) throws ProcessingException {
        if (!other.isSuccess() && this.currentLevel.compareTo(LogLevel.ERROR) < 0) {
            this.currentLevel = LogLevel.ERROR;
        }
        for (ProcessingMessage message : other) {
            this.dispatch(message);
        }
    }

    public final String toString() {
        return Objects.toStringHelper(this).add("log level", (Object)this.logLevel).add("exception threshold", (Object)this.exceptionThreshold).add("current", (Object)this.currentLevel).toString();
    }
}

