/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref;

import java.net.URI;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;

final class JarJsonRef
extends JsonRef {
    private final String jarPrefix;
    private final URI pathURI;

    JarJsonRef(URI uri) {
        super(uri);
        String str = uri.toString();
        int index = str.indexOf(33);
        this.jarPrefix = str.substring(0, index + 1);
        String path = str.substring(index + 1);
        this.pathURI = URI.create(path);
    }

    private JarJsonRef(URI uri, String jarPrefix, URI pathURI) {
        super(uri);
        this.jarPrefix = jarPrefix;
        this.pathURI = pathURI;
    }

    @Override
    public boolean isAbsolute() {
        return this.legal && this.pointer.isEmpty();
    }

    @Override
    public JsonRef resolve(JsonRef other) {
        if (other.uri.isAbsolute()) {
            return other;
        }
        URI targetPath = this.pathURI.resolve(other.uri);
        URI targetURI = URI.create(this.jarPrefix + targetPath.toString());
        return new JarJsonRef(targetURI, this.jarPrefix, targetPath);
    }
}

