/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation;

import java.util.ArrayList;
import java.util.Collections;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.InvalidSchemaException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.CachingProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ArraySchemaDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ArraySchemaSelector;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ObjectSchemaDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ObjectSchemaSelector;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.JsonTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.LoadingCache;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;

public final class ValidationProcessor
implements Processor<FullData, FullData> {
    private final Processor<SchemaContext, ValidatorList> processor;
    private final LoadingCache<JsonNode, ArraySchemaSelector> arrayCache;
    private final LoadingCache<JsonNode, ObjectSchemaSelector> objectCache;

    public ValidationProcessor(Processor<SchemaContext, ValidatorList> processor) {
        this.processor = new CachingProcessor<SchemaContext, ValidatorList>(processor, SchemaContextEquivalence.getInstance());
        this.arrayCache = CacheBuilder.newBuilder().build(ValidationProcessor.arrayLoader());
        this.objectCache = CacheBuilder.newBuilder().build(ValidationProcessor.objectLoader());
    }

    @Override
    public FullData process(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaContext context = new SchemaContext(input);
        ValidatorList fullContext = this.processor.process(report, context);
        if (fullContext == null) {
            throw new InvalidSchemaException(new ProcessingMessage().message(SyntaxMessages.INVALID_SCHEMA));
        }
        SchemaContext newContext = fullContext.getContext();
        FullData data = new FullData(newContext.getSchema(), input.getInstance());
        for (KeywordValidator validator : fullContext) {
            validator.validate(this, report, data);
        }
        if (!report.isSuccess()) {
            return input;
        }
        JsonNode node = data.getInstance().getNode();
        if (node.size() == 0) {
            return input;
        }
        if (node.isArray()) {
            this.processArray(report, data);
        } else {
            this.processObject(report, data);
        }
        return input;
    }

    private void processArray(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ArraySchemaDigester.getInstance().digest(schema);
        ArraySchemaSelector selector = this.arrayCache.getUnchecked(digest);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonTree newInstance = instance.append(JsonPointer.of(index, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(index)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private void processObject(ProcessingReport report, FullData input) throws ProcessingException {
        SchemaTree tree = input.getSchema();
        JsonTree instance = input.getInstance();
        JsonNode schema = tree.getNode();
        JsonNode node = instance.getNode();
        JsonNode digest = ObjectSchemaDigester.getInstance().digest(schema);
        ObjectSchemaSelector selector = this.objectCache.getUnchecked(digest);
        ArrayList<String> fields = Lists.newArrayList(node.fieldNames());
        Collections.sort(fields);
        for (String field : fields) {
            JsonTree newInstance = instance.append(JsonPointer.of(field, new Object[0]));
            FullData data = input.withInstance(newInstance);
            for (JsonPointer ptr : selector.selectSchemas(field)) {
                data = data.withSchema(tree.append(ptr));
                this.process(report, data);
            }
        }
    }

    private static CacheLoader<JsonNode, ArraySchemaSelector> arrayLoader() {
        return new CacheLoader<JsonNode, ArraySchemaSelector>(){

            @Override
            public ArraySchemaSelector load(JsonNode key) {
                return new ArraySchemaSelector(key);
            }
        };
    }

    private static CacheLoader<JsonNode, ObjectSchemaSelector> objectLoader() {
        return new CacheLoader<JsonNode, ObjectSchemaSelector>(){

            @Override
            public ObjectSchemaSelector load(JsonNode key) {
                return new ObjectSchemaSelector(key);
            }
        };
    }

    public String toString() {
        return "validation processor";
    }
}

