/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.CachingProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessorChain;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.build.ValidatorBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.digest.SchemaDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.format.FormatProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.ref.RefResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax.SyntaxProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.SchemaContextEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.SchemaTreeEquivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;

public final class ValidationChain
implements Processor<SchemaContext, ValidatorList> {
    private final Processor<SchemaHolder, SchemaHolder> resolver;
    private final Processor<SchemaContext, ValidatorList> builder;

    public ValidationChain(RefResolver refResolver, Library library, boolean useFormat) {
        SyntaxProcessor syntaxProcessor = new SyntaxProcessor(library.getSyntaxCheckers());
        ProcessorChain<SchemaHolder, SchemaHolder> chain1 = ProcessorChain.startWith(refResolver).chainWith(syntaxProcessor);
        this.resolver = new CachingProcessor<SchemaHolder, SchemaHolder>(chain1.getProcessor(), SchemaHolderEquivalence.INSTANCE);
        SchemaDigester digester = new SchemaDigester(library);
        ValidatorBuilder keywordBuilder = new ValidatorBuilder(library);
        ProcessorChain<SchemaContext, ValidatorList> chain2 = ProcessorChain.startWith(digester).chainWith(keywordBuilder);
        if (useFormat) {
            FormatProcessor format = new FormatProcessor(library);
            chain2 = chain2.chainWith(format);
        }
        this.builder = new CachingProcessor<SchemaContext, ValidatorList>(chain2.getProcessor(), SchemaContextEquivalence.getInstance());
    }

    @Override
    public ValidatorList process(ProcessingReport report, SchemaContext input) throws ProcessingException {
        SchemaHolder in = new SchemaHolder(input.getSchema());
        ListProcessingReport r = new ListProcessingReport(report);
        SchemaHolder out = this.resolver.process(r, in);
        report.mergeWith(r);
        if (!r.isSuccess()) {
            return null;
        }
        SchemaContext output = new SchemaContext((SchemaTree)out.getValue(), input.getInstanceType());
        return this.builder.process(report, output);
    }

    public String toString() {
        return this.resolver + " -> " + this.builder;
    }

    private static final class SchemaHolderEquivalence
    extends Equivalence<SchemaHolder> {
        private static final Equivalence<SchemaHolder> INSTANCE = new SchemaHolderEquivalence();
        private static final Equivalence<SchemaTree> EQUIVALENCE = SchemaTreeEquivalence.getInstance();

        private SchemaHolderEquivalence() {
        }

        @Override
        protected boolean doEquivalent(SchemaHolder a, SchemaHolder b) {
            return EQUIVALENCE.equivalent((SchemaTree)a.getValue(), (SchemaTree)b.getValue());
        }

        @Override
        protected int doHash(SchemaHolder t) {
            return EQUIVALENCE.hash((SchemaTree)t.getValue());
        }
    }
}

