/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation;

import java.util.HashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.digest.Digester;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Ordering;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class ObjectSchemaDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new ObjectSchemaDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private ObjectSchemaDigester() {
        super("", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ret.put("hasAdditional", schema.path("additionalProperties").isObject());
        ArrayNode node = FACTORY.arrayNode();
        ret.put("properties", node);
        HashSet<String> set = Sets.newHashSet(schema.path("properties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set)) {
            node.add(field);
        }
        node = FACTORY.arrayNode();
        ret.put("patternProperties", node);
        set = Sets.newHashSet(schema.path("patternProperties").fieldNames());
        for (String field : Ordering.natural().sortedCopy(set)) {
            node.add(field);
        }
        return ret;
    }
}

