/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.syntax.SyntaxChecker;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.SyntaxMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Ordering;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class SyntaxProcessor
implements Processor<SchemaHolder, SchemaHolder> {
    private final Map<String, SyntaxChecker> checkers;

    public SyntaxProcessor(Dictionary<SyntaxChecker> dict) {
        this.checkers = dict.entries();
    }

    @Override
    public SchemaHolder process(ProcessingReport report, SchemaHolder input) throws ProcessingException {
        this.validate(report, (SchemaTree)input.getValue());
        return input;
    }

    private void validate(ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = tree.getNode();
        NodeType type = NodeType.getNodeType(node);
        if (type != NodeType.OBJECT) {
            ProcessingMessage msg = SyntaxProcessor.newMsg(tree).message(SyntaxMessages.NOT_A_SCHEMA).put("found", type);
            report.error(msg);
            return;
        }
        TreeMap<String, SyntaxChecker> map = Maps.newTreeMap();
        map.putAll(this.checkers);
        HashSet<String> fieldNames = Sets.newHashSet(node.fieldNames());
        map.keySet().retainAll(fieldNames);
        fieldNames.removeAll(map.keySet());
        if (!fieldNames.isEmpty()) {
            report.warn(SyntaxProcessor.newMsg(tree).message(SyntaxMessages.UNKNOWN_KEYWORDS).put("ignored", Ordering.natural().sortedCopy(fieldNames)));
        }
        ArrayList<JsonPointer> pointers = Lists.newArrayList();
        for (SyntaxChecker checker : map.values()) {
            checker.checkSyntax(pointers, report, tree);
        }
        for (JsonPointer pointer : pointers) {
            this.validate(report, tree.append(pointer));
        }
    }

    private static ProcessingMessage newMsg(SchemaTree tree) {
        return new ProcessingMessage().put("schema", tree).put("domain", "syntax");
    }

    public String toString() {
        return "syntax checker";
    }
}

