/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.ref;

import java.util.LinkedHashSet;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.JsonReferenceException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.SchemaLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.RefProcessingMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaHolder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Sets;

public final class RefResolver
implements Processor<SchemaHolder, SchemaHolder> {
    private final SchemaLoader loader;

    public RefResolver(SchemaLoader loader) {
        this.loader = loader;
    }

    @Override
    public SchemaHolder process(ProcessingReport report, SchemaHolder input) throws ProcessingException {
        return new SchemaHolder(this.loadRef((SchemaTree)input.getValue()));
    }

    private static JsonRef nodeAsRef(JsonNode node) {
        JsonNode refNode = node.path("$ref");
        if (!refNode.isTextual()) {
            return null;
        }
        try {
            return JsonRef.fromString(refNode.textValue());
        }
        catch (JsonReferenceException ignored) {
            return null;
        }
    }

    private SchemaTree loadRef(SchemaTree orig) throws ProcessingException {
        JsonNode node;
        JsonRef ref;
        LinkedHashSet<JsonRef> refs = Sets.newLinkedHashSet();
        SchemaTree tree = orig;
        ProcessingMessage message = new ProcessingMessage().put("schema", tree);
        while ((ref = RefResolver.nodeAsRef(node = tree.getNode())) != null) {
            JsonPointer ptr;
            if (!refs.add(ref = tree.resolve(ref))) {
                message.message(RefProcessingMessages.REF_LOOP).put("ref", ref).put("path", refs);
                throw new ProcessingException(message);
            }
            if (!tree.containsRef(ref)) {
                tree = this.loader.get(ref.getLocator());
            }
            if ((ptr = tree.matchingPointer(ref)) == null) {
                message.message(RefProcessingMessages.DANGLING_REF).put("ref", ref);
                throw new ProcessingException(message);
            }
            tree = tree.setPointer(ptr);
        }
        return tree;
    }

    public String toString() {
        return "ref resolver";
    }
}

