/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.format;

import java.util.ArrayList;
import java.util.Map;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.format.FormatAttribute;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.FormatMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Lists;

public final class FormatProcessor
implements Processor<ValidatorList, ValidatorList> {
    private final Map<String, FormatAttribute> attributes;

    public FormatProcessor(Library library) {
        this.attributes = library.getFormatAttributes().entries();
    }

    public FormatProcessor(Dictionary<FormatAttribute> dict) {
        this.attributes = dict.entries();
    }

    @Override
    public ValidatorList process(ProcessingReport report, ValidatorList input) throws ProcessingException {
        SchemaContext context = input.getContext();
        JsonNode node = context.getSchema().getNode().get("format");
        if (node == null) {
            return input;
        }
        String fmt = node.textValue();
        FormatAttribute attr = this.attributes.get(fmt);
        if (attr == null) {
            report.warn(input.newMessage().put("domain", "validation").put("keyword", "format").message(FormatMessages.FORMAT_NOT_SUPPORTED).put("attribute", fmt));
            return input;
        }
        NodeType type = context.getInstanceType();
        if (!attr.supportedTypes().contains((Object)type)) {
            return input;
        }
        ArrayList<KeywordValidator> validators = Lists.newArrayList(input);
        validators.add(FormatProcessor.formatValidator(attr));
        return new ValidatorList(context, validators);
    }

    private static KeywordValidator formatValidator(final FormatAttribute attr) {
        return new KeywordValidator(){

            @Override
            public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
                attr.validate(report, data);
            }
        };
    }

    public String toString() {
        return "format attribute handler";
    }
}

