/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.build;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.KeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaDigest;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

public final class ValidatorBuilder
implements Processor<SchemaDigest, ValidatorList> {
    private static final String ERRMSG = "failed to build keyword validator";
    private final Map<String, Constructor<? extends KeywordValidator>> constructors;

    public ValidatorBuilder(Library library) {
        this.constructors = library.getValidators().entries();
    }

    public ValidatorBuilder(Dictionary<Constructor<? extends KeywordValidator>> dict) {
        this.constructors = dict.entries();
    }

    @Override
    public ValidatorList process(ProcessingReport report, SchemaDigest input) throws ProcessingException {
        TreeMap<String, KeywordValidator> map = Maps.newTreeMap();
        for (Map.Entry<String, JsonNode> entry : input.getDigests().entrySet()) {
            String keyword = entry.getKey();
            JsonNode digest = entry.getValue();
            Constructor<? extends KeywordValidator> constructor = this.constructors.get(keyword);
            KeywordValidator validator = ValidatorBuilder.buildKeyword(constructor, digest);
            map.put(keyword, validator);
        }
        return new ValidatorList(input.getContext(), map.values());
    }

    private static KeywordValidator buildKeyword(Constructor<? extends KeywordValidator> constructor, JsonNode node) throws ProcessingException {
        try {
            return constructor.newInstance(node);
        }
        catch (InstantiationException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException(ERRMSG, (Throwable)e);
        }
    }

    public String toString() {
        return "validator builder";
    }
}

