/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing;

import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessorBuildError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ProcessingErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.MessageProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;

@Immutable
public final class ProcessorChain<IN extends MessageProvider, OUT extends MessageProvider> {
    private final Processor<IN, OUT> processor;

    public static <X extends MessageProvider, Y extends MessageProvider> ProcessorChain<X, Y> startWith(Processor<X, Y> p) {
        if (p == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        return new ProcessorChain<X, Y>(p);
    }

    private ProcessorChain(Processor<IN, OUT> processor) {
        this.processor = processor;
    }

    public ProcessorChain<IN, OUT> failOnError() {
        return this.failOnError(new ProcessingMessage().message(ProcessingErrors.CHAIN_STOPPED));
    }

    public ProcessorChain<IN, OUT> failOnError(final ProcessingMessage message) {
        Processor fail = new Processor<OUT, OUT>(){

            @Override
            public OUT process(ProcessingReport report, OUT input) throws ProcessingException {
                if (!report.isSuccess()) {
                    throw message.asException();
                }
                return input;
            }
        };
        ProcessorMerger merger = new ProcessorMerger(this.processor, fail);
        return new ProcessorChain<IN, OUT>(merger);
    }

    public <NEWOUT extends MessageProvider> ProcessorChain<IN, NEWOUT> chainWith(Processor<OUT, NEWOUT> p) {
        if (p == null) {
            throw new ProcessorBuildError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        ProcessorMerger merger = new ProcessorMerger(this.processor, p);
        return new ProcessorChain<IN, OUT>(merger);
    }

    public Processor<IN, OUT> getProcessor() {
        return this.processor;
    }

    private static final class ProcessorMerger<X extends MessageProvider, Y extends MessageProvider, Z extends MessageProvider>
    implements Processor<X, Z> {
        private final Processor<X, Y> p1;
        private final Processor<Y, Z> p2;

        private ProcessorMerger(Processor<X, Y> p1, Processor<Y, Z> p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        @Override
        public Z process(ProcessingReport report, X input) throws ProcessingException {
            Y intermediate = this.p1.process(report, input);
            return this.p2.process(report, intermediate);
        }

        public String toString() {
            return this.p1 + " -> " + this.p2;
        }
    }
}

