/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing;

import java.util.concurrent.ExecutionException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.ProcessingError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.ProcessingErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessingResult;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.MessageProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.equivalence.Equivalences;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Equivalence;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.CacheLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.cache.LoadingCache;

public final class CachingProcessor<IN extends MessageProvider, OUT extends MessageProvider>
implements Processor<IN, OUT> {
    private final Processor<IN, OUT> processor;
    private final Equivalence<IN> equivalence;
    private final LoadingCache<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> cache;

    public CachingProcessor(Processor<IN, OUT> processor) {
        this(processor, Equivalences.equals());
    }

    public CachingProcessor(Processor<IN, OUT> processor, Equivalence<IN> equivalence) {
        if (processor == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_PROCESSOR));
        }
        if (equivalence == null) {
            throw new ProcessingError(new ProcessingMessage().message(ProcessingErrors.NULL_EQUIVALENCE));
        }
        this.processor = processor;
        this.equivalence = equivalence;
        this.cache = CacheBuilder.newBuilder().build(this.loader());
    }

    @Override
    public OUT process(ProcessingReport report, IN input) throws ProcessingException {
        ProcessingResult<OUT> result;
        try {
            result = this.cache.get(this.equivalence.wrap(input));
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
        report.mergeWith(result.getReport());
        return result.getResult();
    }

    private CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>> loader() {
        return new CacheLoader<Equivalence.Wrapper<IN>, ProcessingResult<OUT>>(){

            @Override
            public ProcessingResult<OUT> load(Equivalence.Wrapper<IN> key) throws ProcessingException {
                MessageProvider input = (MessageProvider)key.get();
                ListProcessingReport report = new ListProcessingReport(LogLevel.DEBUG, LogLevel.NONE);
                return ProcessingResult.of(CachingProcessor.this.processor, report, input);
            }
        };
    }

    public String toString() {
        return "CACHED[" + this.processor + ']';
    }
}

