/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main;

import java.util.Map;
import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.LoadingConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.JsonReferenceError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.LoadingConfigurationError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Library;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.load.SchemaLoader;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchema;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonSchemaFactoryBuilder;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main.JsonValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.JsonReferenceErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.LoadingConfigurationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessorMap;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.SchemaContext;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.ValidatorList;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.ref.RefResolver;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.syntax.SyntaxValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ValidationChain;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.ref.JsonRef;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ReportProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.Frozen;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.base.Function;

@Immutable
public final class JsonSchemaFactory
implements Frozen<JsonSchemaFactoryBuilder> {
    final ReportProvider reportProvider;
    final LoadingConfiguration loadingCfg;
    final ValidationConfiguration validationCfg;
    private final SchemaLoader loader;
    private final JsonValidator validator;
    private final SyntaxValidator syntaxValidator;

    public static JsonSchemaFactory byDefault() {
        return JsonSchemaFactory.newBuilder().freeze();
    }

    public static JsonSchemaFactoryBuilder newBuilder() {
        return new JsonSchemaFactoryBuilder();
    }

    JsonSchemaFactory(JsonSchemaFactoryBuilder builder) {
        this.reportProvider = builder.reportProvider;
        this.loadingCfg = builder.loadingCfg;
        this.validationCfg = builder.validationCfg;
        this.loader = new SchemaLoader(this.loadingCfg);
        Processor<SchemaContext, ValidatorList> processor = this.buildProcessor();
        this.validator = new JsonValidator(this.loader, new ValidationProcessor(processor), this.reportProvider);
        this.syntaxValidator = new SyntaxValidator(this.validationCfg);
    }

    public JsonValidator getValidator() {
        return this.validator;
    }

    public SyntaxValidator getSyntaxValidator() {
        return this.syntaxValidator;
    }

    public JsonSchema getJsonSchema(JsonNode schema) throws ProcessingException {
        if (schema == null) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        return this.validator.buildJsonSchema(schema, JsonPointer.empty());
    }

    public JsonSchema getJsonSchema(JsonNode schema, String ptr) throws ProcessingException {
        if (schema == null) {
            throw new LoadingConfigurationError(new ProcessingMessage().message(LoadingConfigurationMessages.NULL_SCHEMA));
        }
        if (ptr == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_JSON_POINTER));
        }
        return this.validator.buildJsonSchema(schema, new JsonPointer(ptr));
    }

    public JsonSchema getJsonSchema(String uri) throws ProcessingException {
        if (uri == null) {
            throw new JsonReferenceError(new ProcessingMessage().message(JsonReferenceErrors.NULL_URI));
        }
        return this.validator.buildJsonSchema(uri);
    }

    public Processor<FullData, FullData> getProcessor() {
        return this.validator.getProcessor();
    }

    @Override
    public JsonSchemaFactoryBuilder thaw() {
        return new JsonSchemaFactoryBuilder(this);
    }

    private Processor<SchemaContext, ValidatorList> buildProcessor() {
        RefResolver resolver = new RefResolver(this.loader);
        boolean useFormat = this.validationCfg.getUseFormat();
        Map<JsonRef, Library> libraries = this.validationCfg.getLibraries();
        Library defaultLibrary = this.validationCfg.getDefaultLibrary();
        ValidationChain defaultChain = new ValidationChain(resolver, defaultLibrary, useFormat);
        ProcessorMap<JsonRef, SchemaContext, ValidatorList> map = new FullChain().setDefaultProcessor(defaultChain);
        for (Map.Entry<JsonRef, Library> entry : libraries.entrySet()) {
            JsonRef ref = entry.getKey();
            ValidationChain chain = new ValidationChain(resolver, entry.getValue(), useFormat);
            map = map.addEntry(ref, chain);
        }
        return map.getProcessor();
    }

    private static final class FullChain
    extends ProcessorMap<JsonRef, SchemaContext, ValidatorList> {
        private FullChain() {
        }

        @Override
        protected Function<SchemaContext, JsonRef> f() {
            return new Function<SchemaContext, JsonRef>(){

                @Override
                public JsonRef apply(SchemaContext input) {
                    return input.getSchema().getDollarSchema();
                }
            };
        }
    }
}

