/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.main;

import net.jcip.annotations.Immutable;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.ProcessingResult;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.validation.ValidationProcessor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ReportProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SimpleJsonTree;

@Immutable
public final class JsonSchema {
    private final ValidationProcessor processor;
    private final SchemaTree schema;
    private final ReportProvider reportProvider;

    JsonSchema(ValidationProcessor processor, SchemaTree schema, ReportProvider reportProvider) {
        this.processor = processor;
        this.schema = schema;
        this.reportProvider = reportProvider;
    }

    private ProcessingReport doValidate(JsonNode node) throws ProcessingException {
        FullData data = new FullData(this.schema, new SimpleJsonTree(node));
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult<FullData> result = ProcessingResult.of(this.processor, report, data);
        return result.getReport();
    }

    private ProcessingReport doValidateUnchecked(JsonNode node) {
        FullData data = new FullData(this.schema, new SimpleJsonTree(node));
        ProcessingReport report = this.reportProvider.newReport();
        ProcessingResult<FullData> result = ProcessingResult.uncheckedResult(this.processor, report, data);
        return result.getReport();
    }

    public ProcessingReport validate(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance);
    }

    public ProcessingReport validateUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance);
    }

    public boolean validInstance(JsonNode instance) throws ProcessingException {
        return this.doValidate(instance).isSuccess();
    }

    public boolean validInstanceUnchecked(JsonNode instance) {
        return this.doValidateUnchecked(instance).isSuccess();
    }
}

