/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library;

import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.unchecked.DictionaryBuildError;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.library.Dictionary;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.DictionaryBuildErrors;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingMessage;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.Thawed;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.google.common.collect.Maps;

@NotThreadSafe
public final class DictionaryBuilder<T>
implements Thawed<Dictionary<T>> {
    final Map<String, T> entries = Maps.newHashMap();

    DictionaryBuilder() {
    }

    DictionaryBuilder(Dictionary<T> dict) {
        this.entries.putAll(dict.entries);
    }

    public DictionaryBuilder<T> addEntry(String key, T value) {
        if (key == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_KEY));
        }
        if (value == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_VALUE));
        }
        this.entries.put(key, value);
        return this;
    }

    public DictionaryBuilder<T> addAll(Dictionary<T> other) {
        if (other == null) {
            throw new DictionaryBuildError(new ProcessingMessage().message(DictionaryBuildErrors.NULL_DICT));
        }
        this.entries.putAll(other.entries);
        return this;
    }

    public DictionaryBuilder<T> removeEntry(String key) {
        this.entries.remove(key);
        return this;
    }

    @Override
    public Dictionary<T> freeze() {
        return new Dictionary(this);
    }
}

