/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers;

import java.math.BigDecimal;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers.NumericValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;

public abstract class DivisorValidator
extends NumericValidator {
    protected DivisorValidator(String keyword, JsonNode digest) {
        super(keyword, digest);
    }

    @Override
    protected final void validateLong(ProcessingReport report, FullData data) throws ProcessingException {
        long longValue;
        JsonNode node = data.getInstance().getNode();
        long instanceValue = node.longValue();
        long remainder = instanceValue % (longValue = this.number.longValue());
        if (remainder == 0L) {
            return;
        }
        report.error(this.newMsg(data).message(KeywordValidationMessages.NON_ZERO_DIVISION_REMAINDER).put("value", node).put("divisor", this.number));
    }

    @Override
    protected final void validateDecimal(ProcessingReport report, FullData data) throws ProcessingException {
        BigDecimal decimalValue;
        JsonNode node = data.getInstance().getNode();
        BigDecimal instanceValue = node.decimalValue();
        BigDecimal remainder = instanceValue.remainder(decimalValue = this.number.decimalValue());
        if (remainder.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        report.error(this.newMsg(data).message(KeywordValidationMessages.NON_ZERO_DIVISION_REMAINDER).put("value", node).put("divisor", this.number));
    }
}

