/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.draftv4;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers.SchemaArrayValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;

public final class AnyOfValidator
extends SchemaArrayValidator {
    public AnyOfValidator(JsonNode digest) {
        super("anyOf");
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        JsonNode schemas = tree.getNode().get(this.keyword);
        int size = schemas.size();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        for (int index = 0; index < size; ++index) {
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess == 0) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.ANYOF_FAIL).put("reports", fullReport));
        }
    }
}

