/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.draftv3;

import java.util.Iterator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class DraftV3TypeValidator
extends DraftV3TypeKeywordValidator {
    public DraftV3TypeValidator(JsonNode digest) {
        super("type", digest);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        boolean primitiveOK = this.types.contains((Object)type);
        if (primitiveOK) {
            return;
        }
        ObjectNode fullReport = FACTORY.objectNode();
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        int nrSuccess = 0;
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess >= 1) {
            return;
        }
        if (!this.types.isEmpty()) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.TYPE_NO_MATCH).put("expected", this.types).put("found", type));
        }
        if (!this.schemas.isEmpty()) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.ANYOF_FAIL).put("reports", fullReport));
        }
    }
}

