/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.draftv3;

import java.util.Iterator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.jsonpointer.JsonPointer;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.helpers.DraftV3TypeKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ListProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.LogLevel;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.tree.SchemaTree;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.util.NodeType;

public final class DisallowKeywordValidator
extends DraftV3TypeKeywordValidator {
    public DisallowKeywordValidator(JsonNode digested) {
        super("disallow", digested);
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        NodeType type = NodeType.getNodeType(instance);
        if (this.types.contains((Object)type)) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.DISALLOWED_TYPE).put("disallowed", this.types).put("found", type));
            return;
        }
        SchemaTree tree = data.getSchema();
        JsonPointer schemaPointer = tree.getPointer();
        ObjectNode fullReport = FACTORY.objectNode();
        int nrSuccess = 0;
        Iterator iterator = this.schemas.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            ListProcessingReport subReport = new ListProcessingReport(report.getLogLevel(), LogLevel.FATAL);
            JsonPointer ptr = schemaPointer.append(JsonPointer.of(this.keyword, index));
            FullData newData = data.withSchema(tree.setPointer(ptr));
            processor.process(subReport, newData);
            fullReport.put(ptr.toString(), subReport.asJson());
            if (!subReport.isSuccess()) continue;
            ++nrSuccess;
        }
        if (nrSuccess != 0) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.DISALLOW_SCHEMA).put("reports", fullReport));
        }
    }
}

