/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.common;

import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.exceptions.ProcessingException;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.messages.KeywordValidationMessages;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processing.Processor;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.processors.data.FullData;
import org.jenkinsci.plugins.pipeline.modeldefinition.shaded.com.github.fge.jsonschema.report.ProcessingReport;

public final class AdditionalItemsValidator
extends AbstractKeywordValidator {
    private final boolean additionalOK;
    private final int itemsSize;

    public AdditionalItemsValidator(JsonNode digest) {
        super("additionalItems");
        this.additionalOK = digest.get(this.keyword).booleanValue();
        this.itemsSize = digest.get("itemsSize").intValue();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, FullData data) throws ProcessingException {
        if (this.additionalOK) {
            return;
        }
        int size = data.getInstance().getNode().size();
        if (size > this.itemsSize) {
            report.error(this.newMsg(data).message(KeywordValidationMessages.ADDITIONAL_ITEMS_NOT_ALLOWED).put("allowed", this.itemsSize).put("found", size));
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + (this.additionalOK ? "allowed" : this.itemsSize + " max");
    }
}

